/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.connection;

import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.connection.ConnectionSelectionStrategy;
import io.tarantool.driver.api.connection.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.api.connection.TarantoolConnection;
import io.tarantool.driver.core.connection.TarantoolConnectionIterator;
import io.tarantool.driver.exceptions.NoAvailableConnectionsException;
import io.tarantool.driver.utils.Assert;
import io.tarantool.driver.utils.CyclingIterator;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class TarantoolConnectionSelectionStrategies {

    static final class ParallelRoundRobinStrategy
    implements ConnectionSelectionStrategy {
        private final TarantoolClientConfig config;
        private final CyclingIterator<TarantoolConnectionIterator> iteratorsIterator;
        private final AtomicInteger available;

        ParallelRoundRobinStrategy(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            this.config = config;
            this.available = new AtomicInteger(connections.size());
            this.iteratorsIterator = new CyclingIterator<TarantoolConnectionIterator>(this.populateIterators(connections));
        }

        private Collection<TarantoolConnectionIterator> populateIterators(Collection<TarantoolConnection> connections) {
            int groupSize = this.config.getConnections();
            AtomicInteger currentSize = new AtomicInteger(0);
            return connections.stream().peek(conn -> conn.addConnectionCloseListener(c -> this.available.getAndDecrement())).collect(Collectors.groupingBy(conn -> currentSize.getAndIncrement() / groupSize)).values().stream().map(TarantoolConnectionIterator::new).filter(CyclingIterator::hasNext).collect(Collectors.toList());
        }

        @Override
        public TarantoolConnection next() throws NoAvailableConnectionsException {
            if (this.available.get() > 0) {
                while (this.iteratorsIterator.hasNext()) {
                    TarantoolConnection connection = (TarantoolConnection)this.iteratorsIterator.next().next();
                    if (!connection.isConnected()) continue;
                    return connection;
                }
            }
            throw new NoAvailableConnectionsException();
        }
    }

    public static enum ParallelRoundRobinStrategyFactory implements ConnectionSelectionStrategyFactory
    {
        INSTANCE;


        @Override
        public ConnectionSelectionStrategy create(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            Assert.notNull(connections, "The collection of Tarantool connections should not be null");
            return new ParallelRoundRobinStrategy(config, connections);
        }
    }

    static final class RoundRobinStrategy
    implements ConnectionSelectionStrategy {
        private final TarantoolConnectionIterator connectionIterator;
        private final AtomicInteger available;

        RoundRobinStrategy(Collection<TarantoolConnection> connections) {
            this.available = new AtomicInteger(connections.size());
            this.connectionIterator = new TarantoolConnectionIterator(connections.stream().peek(conn -> conn.addConnectionCloseListener(c -> this.available.getAndDecrement())).collect(Collectors.toList()));
        }

        @Override
        public TarantoolConnection next() throws NoAvailableConnectionsException {
            if (this.available.get() > 0) {
                while (this.connectionIterator.hasNext()) {
                    TarantoolConnection connection = (TarantoolConnection)this.connectionIterator.next();
                    if (!connection.isConnected()) continue;
                    return connection;
                }
            }
            throw new NoAvailableConnectionsException();
        }
    }

    public static enum RoundRobinStrategyFactory implements ConnectionSelectionStrategyFactory
    {
        INSTANCE;


        @Override
        public ConnectionSelectionStrategy create(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            Assert.notNull(connections, "The collection of Tarantool connections should not be null");
            return new RoundRobinStrategy(connections);
        }
    }
}

