/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.retry;

import io.tarantool.driver.api.retry.TarantoolRequestRetryPolicies;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class RequestTimeoutOperation<T>
implements Supplier<CompletableFuture<T>> {
    private final CompletableFuture<T> resultFuture;
    private final long requestTimeout;

    public RequestTimeoutOperation(CompletableFuture<T> resultFuture, long requestTimeout) {
        this.resultFuture = resultFuture;
        this.requestTimeout = requestTimeout;
    }

    @Override
    public CompletableFuture<T> get() {
        CompletableFuture future = new CompletableFuture();
        ScheduledFuture<Boolean> scheduledFuture = TarantoolRequestRetryPolicies.getTimeoutScheduler().schedule(() -> {
            TimeoutException ex = new TimeoutException("Request timeout after " + this.requestTimeout + " ms");
            return future.completeExceptionally(ex);
        }, this.requestTimeout, TimeUnit.MILLISECONDS);
        this.resultFuture.whenComplete((res, ex) -> scheduledFuture.cancel(false));
        return future;
    }
}

