/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.retry;

import io.tarantool.driver.api.retry.RequestRetryPolicy;
import io.tarantool.driver.api.retry.RequestTimeoutOperation;
import io.tarantool.driver.api.retry.TarantoolRequestRetryPolicies;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingAsyncOperation<T>
implements Runnable {
    protected final Supplier<CompletableFuture<T>> operation;
    protected final CompletableFuture<T> resultFuture;
    protected final AtomicReference<Throwable> lastExceptionWrapper;
    protected final RequestTimeoutOperation<T> requestTimeoutOperation;
    protected final RequestRetryPolicy policy;
    private final Logger log = LoggerFactory.getLogger(RetryingAsyncOperation.class);

    public RetryingAsyncOperation(RequestRetryPolicy policy, Supplier<CompletableFuture<T>> operation, CompletableFuture<T> resultFuture, AtomicReference<Throwable> lastExceptionWrapper) {
        this.operation = operation;
        this.resultFuture = resultFuture;
        this.lastExceptionWrapper = lastExceptionWrapper;
        this.requestTimeoutOperation = new RequestTimeoutOperation<T>(resultFuture, policy.getRequestTimeout());
        this.policy = policy;
    }

    @Override
    public void run() {
        CompletableFuture<T> operationFuture = this.operation.get();
        Object requestTimeoutFuture = this.requestTimeoutOperation.get();
        ((CompletableFuture)operationFuture.acceptEither((CompletionStage)requestTimeoutFuture, this.resultFuture::complete)).whenComplete((futureResult, ex) -> {
            try {
                if (this.resultFuture.isDone()) {
                    return;
                }
                while (ex instanceof ExecutionException || ex instanceof CompletionException) {
                    ex = ex.getCause();
                }
                this.lastExceptionWrapper.set((Throwable)ex);
                this.log.debug("Retrying exception - " + ex.getMessage());
                if (this.policy.canRetryRequest((Throwable)ex)) {
                    ScheduledFuture<?> delayFuture = TarantoolRequestRetryPolicies.getTimeoutScheduler().schedule(this, this.policy.getDelay(), TimeUnit.MILLISECONDS);
                    this.resultFuture.whenComplete((r, e) -> delayFuture.cancel(false));
                } else {
                    this.resultFuture.completeExceptionally(this.policy.getPolicyException((Throwable)ex));
                }
            }
            catch (Exception internalException) {
                this.resultFuture.completeExceptionally(internalException);
            }
        });
    }
}

