/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.space.options.proxy;

import io.tarantool.driver.api.space.options.BaseOptions;
import io.tarantool.driver.api.space.options.SelectOptions;
import java.util.Optional;

public final class ProxySelectOptions
extends BaseOptions
implements SelectOptions<ProxySelectOptions> {
    public static final String BATCH_SIZE = "batch_size";

    private ProxySelectOptions() {
    }

    public static ProxySelectOptions create() {
        return new ProxySelectOptions();
    }

    public ProxySelectOptions withBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch size should be greater than 0");
        }
        this.addOption(BATCH_SIZE, batchSize);
        return this.self();
    }

    @Override
    public ProxySelectOptions self() {
        return this;
    }

    @Override
    public Optional<Integer> getBatchSize() {
        return this.getOption(BATCH_SIZE, Integer.class);
    }
}

