/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.codecs;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolRequest;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;

public class MessagePackFrameEncoder
extends MessageToByteEncoder<TarantoolRequest> {
    private static final int MINIMAL_HEADER_SIZE = 5;
    private final MessagePackObjectMapper mapper;

    public MessagePackFrameEncoder(MessagePackObjectMapper mapper) {
        this.mapper = mapper;
    }

    protected void encode(ChannelHandlerContext ctx, TarantoolRequest tarantoolRequest, ByteBuf byteBuf) throws Exception {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        tarantoolRequest.toMessagePack((MessagePacker)packer, this.mapper);
        long outputSize = packer.getTotalWrittenBytes();
        byteBuf.capacity((int)(outputSize + 5L));
        byte[] output = packer.toByteArray();
        packer.clear();
        packer.packLong(outputSize);
        byteBuf.writeBytes(packer.toByteArray());
        packer.close();
        byteBuf.writeBytes(output);
    }
}

