/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.TarantoolVersion;
import io.tarantool.driver.api.MultiValueCallResult;
import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.connection.TarantoolConnectionListeners;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolMetadataProvider;
import io.tarantool.driver.api.retry.RequestRetryPolicy;
import io.tarantool.driver.api.retry.RequestRetryPolicyFactory;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.core.space.RetryingTarantoolSpace;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.factories.ResultMapperFactoryFactory;
import io.tarantool.driver.protocol.Packable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.msgpack.value.Value;

public abstract class RetryingTarantoolClient<T extends Packable, R extends Collection<T>>
implements TarantoolClient<T, R> {
    private final TarantoolClient<T, R> client;
    private final RequestRetryPolicyFactory retryPolicyFactory;
    private final Executor executor;

    public RetryingTarantoolClient(TarantoolClient<T, R> decoratedClient, RequestRetryPolicyFactory retryPolicyFactory) {
        this(decoratedClient, retryPolicyFactory, Executors.newWorkStealingPool());
    }

    public RetryingTarantoolClient(TarantoolClient<T, R> decoratedClient, RequestRetryPolicyFactory retryPolicyFactory, Executor executor) {
        this.client = decoratedClient;
        this.retryPolicyFactory = retryPolicyFactory;
        this.executor = executor;
    }

    @Override
    public TarantoolMetadataProvider metadataProvider() {
        return this.client.metadataProvider();
    }

    @Override
    public TarantoolClientConfig getConfig() {
        return this.client.getConfig();
    }

    @Override
    public TarantoolVersion getVersion() throws TarantoolClientException {
        return this.client.getVersion();
    }

    @Override
    public TarantoolSpaceOperations<T, R> space(String spaceName) throws TarantoolClientException {
        TarantoolSpaceOperations<T, R> wrappedSpace = this.getTarantoolSpaceOperationsRetrying(() -> this.client.space(spaceName));
        return this.spaceOperations(wrappedSpace, this.retryPolicyFactory, this.executor);
    }

    @Override
    public TarantoolSpaceOperations<T, R> space(int spaceId) throws TarantoolClientException {
        TarantoolSpaceOperations<T, R> wrappedSpace = this.getTarantoolSpaceOperationsRetrying(() -> this.client.space(spaceId));
        return this.spaceOperations(wrappedSpace, this.retryPolicyFactory, this.executor);
    }

    protected abstract RetryingTarantoolSpace<T, R> spaceOperations(TarantoolSpaceOperations<T, R> var1, RequestRetryPolicyFactory var2, Executor var3);

    @Override
    public TarantoolMetadataOperations metadata() throws TarantoolClientException {
        return this.client.metadata();
    }

    @Override
    public TarantoolConnectionListeners getConnectionListeners() {
        return this.client.getConnectionListeners();
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.call(functionName));
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, Object ... arguments) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.call(functionName, arguments));
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, List<?> arguments) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.call(functionName, arguments));
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, List<?> arguments, MessagePackMapper mapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.call(functionName, arguments, mapper));
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> callForTupleResult(String functionName, Class<T> entityClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForTupleResult(functionName, entityClass));
    }

    @Override
    public <T> CompletableFuture<T> call(String functionName, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.call(functionName, resultMapper));
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> callForTupleResult(String functionName, List<?> arguments, Class<T> entityClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForTupleResult(functionName, arguments, entityClass));
    }

    @Override
    public <T> CompletableFuture<T> call(String functionName, List<?> arguments, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.call(functionName, arguments, resultMapper));
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> callForTupleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Class<T> entityClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForTupleResult(functionName, arguments, argumentsMapper, entityClass));
    }

    @Override
    public <T> CompletableFuture<T> call(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.call(functionName, arguments, argumentsMapper, resultMapper));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Class<T> resultClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, arguments, argumentsMapper, resultClass));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, arguments, argumentsMapper, valueConverter));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, arguments, argumentsMapper, resultMapper));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, Class<T> resultClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, arguments, resultClass));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, arguments, valueConverter));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, arguments, resultMapper));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, Class<T> resultClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, resultClass));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, valueConverter));
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForSingleResult(functionName, resultMapper));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, arguments, argumentsMapper, resultContainerSupplier, resultClass));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, arguments, argumentsMapper, resultContainerSupplier, valueConverter));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, arguments, argumentsMapper, resultMapper));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, arguments, resultContainerSupplier, resultClass));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, arguments, resultContainerSupplier, valueConverter));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, arguments, resultMapper));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, resultContainerSupplier, resultClass));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, resultContainerSupplier, valueConverter));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.callForMultiResult(functionName, resultMapper));
    }

    @Override
    public ResultMapperFactoryFactory getResultMapperFactoryFactory() {
        return this.client.getResultMapperFactoryFactory();
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.eval(expression));
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.eval(expression, arguments));
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.eval(expression, resultMapper));
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.eval(expression, arguments, resultMapper));
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments, MessagePackObjectMapper argumentsMapper, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        return this.wrapOperation(() -> this.client.eval(expression, arguments, argumentsMapper, resultMapper));
    }

    @Override
    public boolean refresh() {
        return this.client.refresh();
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    protected RequestRetryPolicyFactory getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    protected TarantoolClient<T, R> getClient() {
        return this.client;
    }

    private <S> CompletableFuture<S> wrapOperation(Supplier<CompletableFuture<S>> operation) {
        RequestRetryPolicy retryPolicy = this.retryPolicyFactory.create();
        return retryPolicy.wrapOperation(operation, this.executor);
    }

    private TarantoolSpaceOperations<T, R> getTarantoolSpaceOperationsRetrying(Supplier<TarantoolSpaceOperations<T, R>> spaceSupplier) {
        CompletableFuture wrapperForSync = new CompletableFuture();
        try {
            return (TarantoolSpaceOperations)this.wrapOperation(() -> {
                wrapperForSync.complete(spaceSupplier.get());
                return wrapperForSync;
            }).get();
        }
        catch (InterruptedException e) {
            throw new CompletionException(e);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
    }
}

