/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.exceptions.TarantoolFunctionCallException;
import io.tarantool.driver.exceptions.errors.TarantoolErrorsParser;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.util.List;
import java.util.function.Function;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class SingleValueCallResultImpl<T>
implements SingleValueCallResult<T> {
    private final T value;

    public SingleValueCallResultImpl(ArrayValue result, ValueConverter<Value, T> valueConverter) {
        this.value = this.parseResult(result, valueConverter::fromValue);
    }

    public SingleValueCallResultImpl(ArrayValue result, MessagePackValueMapper valueMapper) {
        this.value = this.parseResult(result, valueMapper::fromValue);
    }

    private T parseResult(ArrayValue result, Function<Value, T> valueGetter) {
        if (result == null) {
            throw new TarantoolFunctionCallException("Function call result is null");
        }
        int callResultSize = result.size();
        Value resultValue = result.getOrNilValue(0);
        Value errorsValue = result.getOrNilValue(1);
        if (callResultSize == 0 || callResultSize == 1 && resultValue.isNilValue()) {
            return null;
        }
        if (callResultSize == 2 && resultValue.isNilValue() && !errorsValue.isNilValue()) {
            throw TarantoolErrorsParser.parse(errorsValue);
        }
        if (callResultSize == 2 && errorsValue.isArrayValue()) {
            List errorsList = errorsValue.asArrayValue().list();
            if (!errorsList.isEmpty()) {
                throw TarantoolErrorsParser.parse((Value)errorsList.get(0));
            }
            throw new TarantoolFunctionCallException("Unexpected error format in the function call result");
        }
        if (callResultSize > 1 && !errorsValue.isNilValue()) {
            throw new TarantoolFunctionCallException("Too many values in the function call result, expected \"[result]\", \"[result, errors]\" or \"[nil, error]\"");
        }
        return valueGetter.apply(resultValue);
    }

    @Override
    public T value() {
        return this.value;
    }
}

