/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolClientConfigurator;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.proxy.ProxyOperationsMappingConfig;
import io.tarantool.driver.api.retry.RequestRetryPolicyFactory;
import io.tarantool.driver.api.retry.TarantoolRequestRetryPolicies;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.core.ProxyTarantoolTupleClient;
import io.tarantool.driver.core.RetryingTarantoolTupleClient;
import io.tarantool.driver.utils.Assert;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class TarantoolClientConfiguratorImpl<SELF extends TarantoolClientConfigurator<SELF>>
implements TarantoolClientConfigurator<SELF> {
    private final TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> client;
    protected RequestRetryPolicyFactory retryPolicyFactory;
    protected ProxyOperationsMappingConfig mappingConfig;
    protected Executor executor;

    public TarantoolClientConfiguratorImpl(TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> client) {
        this.client = client;
    }

    protected TarantoolClientConfiguratorImpl() {
        this.client = null;
    }

    @Override
    public SELF withProxyMethodMapping() {
        return this.withProxyMethodMapping(UnaryOperator.identity());
    }

    @Override
    public SELF withProxyMethodMapping(UnaryOperator<ProxyOperationsMappingConfig.Builder> builder) {
        this.mappingConfig = ((ProxyOperationsMappingConfig.Builder)builder.apply(ProxyOperationsMappingConfig.builder())).build();
        return this.getSelf();
    }

    @Override
    public SELF withRetryingByNumberOfAttempts(int numberOfAttempts) {
        return this.withRetryingByNumberOfAttempts(numberOfAttempts, UnaryOperator.identity());
    }

    @Override
    public SELF withRetryingByNumberOfAttempts(int numberOfAttempts, UnaryOperator<TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder<Predicate<Throwable>>> policy) {
        return this.withRetryingByNumberOfAttempts(numberOfAttempts, TarantoolRequestRetryPolicies.retryNetworkErrors(), policy);
    }

    @Override
    public SELF withRetryingByNumberOfAttempts(int numberOfAttempts, UnaryOperator<TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder<Predicate<Throwable>>> policy, Executor executor) {
        return this.withRetryingByNumberOfAttempts(numberOfAttempts, TarantoolRequestRetryPolicies.retryNetworkErrors(), policy, executor);
    }

    @Override
    public <T extends Predicate<Throwable>> SELF withRetryingByNumberOfAttempts(int numberOfAttempts, T exceptionsCheck, UnaryOperator<TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder<T>> policy) {
        return this.withRetrying(((TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder)policy.apply(TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.builder(numberOfAttempts, exceptionsCheck))).build());
    }

    @Override
    public <T extends Predicate<Throwable>> SELF withRetryingByNumberOfAttempts(int numberOfAttempts, T exceptionsCheck, UnaryOperator<TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder<T>> policy, Executor executor) {
        return this.withRetrying(((TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder)policy.apply(TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.builder(numberOfAttempts, exceptionsCheck))).build(), executor);
    }

    @Override
    public SELF withRetryingIndefinitely(UnaryOperator<TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder<Predicate<Throwable>>> policy, Executor executor) {
        return this.withRetryingIndefinitely(TarantoolRequestRetryPolicies.retryNetworkErrors(), policy, executor);
    }

    @Override
    public SELF withRetryingIndefinitely(UnaryOperator<TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder<Predicate<Throwable>>> policy) {
        return this.withRetryingIndefinitely(TarantoolRequestRetryPolicies.retryNetworkErrors(), policy);
    }

    @Override
    public <T extends Predicate<Throwable>> SELF withRetryingIndefinitely(T callback, UnaryOperator<TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder<T>> policy) {
        return this.withRetrying(((TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder)policy.apply(TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.builder(callback))).build());
    }

    @Override
    public <T extends Predicate<Throwable>> SELF withRetryingIndefinitely(T callback, UnaryOperator<TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder<T>> policy, Executor executor) {
        return this.withRetrying(((TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder)policy.apply(TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.builder(callback))).build(), executor);
    }

    @Override
    public SELF withRetrying(RequestRetryPolicyFactory factory) {
        this.retryPolicyFactory = factory;
        return this.getSelf();
    }

    @Override
    public SELF withRetrying(RequestRetryPolicyFactory factory, Executor executor) {
        this.retryPolicyFactory = factory;
        this.executor = executor;
        return this.getSelf();
    }

    @Override
    public TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> build() {
        return this.decorate(this.client);
    }

    protected TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> decorate(TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> client) {
        Assert.notNull(client, "Tarantool client must not be null!");
        if (this.mappingConfig != null) {
            client = new ProxyTarantoolTupleClient(client, this.mappingConfig);
        }
        if (this.retryPolicyFactory != null) {
            client = this.executor != null ? new RetryingTarantoolTupleClient(client, this.retryPolicyFactory, this.executor) : new RetryingTarantoolTupleClient(client, this.retryPolicyFactory);
        }
        return client;
    }

    private SELF getSelf() {
        return (SELF)this;
    }
}

