/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.tarantool.driver.TarantoolVersionHolder;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.connection.TarantoolConnection;
import io.tarantool.driver.api.connection.TarantoolConnectionListener;
import io.tarantool.driver.api.connection.TarantoolConnectionListeners;
import io.tarantool.driver.core.RequestFutureManager;
import io.tarantool.driver.core.TarantoolChannelInitializer;
import io.tarantool.driver.core.connection.TarantoolConnectionImpl;
import io.tarantool.driver.exceptions.TarantoolClientException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarantoolConnectionFactory {
    protected final TarantoolClientConfig config;
    protected final Bootstrap bootstrap;
    protected final ScheduledExecutorService timeoutScheduler;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public TarantoolConnectionFactory(TarantoolClientConfig config, Bootstrap bootstrap, ScheduledExecutorService timeoutScheduler) {
        this.config = config;
        this.bootstrap = bootstrap;
        this.timeoutScheduler = timeoutScheduler;
    }

    public CompletableFuture<TarantoolConnection> singleConnection(InetSocketAddress serverAddress, TarantoolConnectionListeners connectionListeners) {
        CompletableFuture<Channel> connectionFuture = new CompletableFuture<Channel>();
        RequestFutureManager requestManager = new RequestFutureManager(this.config, this.timeoutScheduler);
        TarantoolVersionHolder versionHolder = new TarantoolVersionHolder();
        TarantoolChannelInitializer handler = new TarantoolChannelInitializer(this.config, requestManager, versionHolder, connectionFuture);
        ChannelFuture future = ((Bootstrap)this.bootstrap.clone().handler((ChannelHandler)handler)).remoteAddress((SocketAddress)serverAddress).connect();
        future.addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                connectionFuture.completeExceptionally(new TarantoolClientException(String.format("Failed to connect to the Tarantool server at %s", serverAddress), f.cause()));
            }
        }));
        this.timeoutScheduler.schedule(() -> {
            if (!connectionFuture.isDone()) {
                connectionFuture.completeExceptionally(new TimeoutException(String.format("Failed to connect to the Tarantool server at %s within %d ms", serverAddress, this.config.getConnectTimeout())));
            }
        }, (long)this.config.getConnectTimeout(), TimeUnit.MILLISECONDS);
        CompletionStage result = connectionFuture.thenApply(ch -> new TarantoolConnectionImpl(requestManager, versionHolder, (Channel)ch));
        for (TarantoolConnectionListener listener : connectionListeners.all()) {
            result = ((CompletableFuture)result).thenCompose(listener::onConnection);
        }
        return ((CompletableFuture)result).handle((connection, ex) -> {
            if (ex != null) {
                this.logger.warn("Connection failed: {}", (Object)ex.getMessage());
                future.channel().close();
            }
            return connection;
        });
    }

    public Collection<CompletableFuture<TarantoolConnection>> multiConnection(InetSocketAddress serverAddress, int connections, TarantoolConnectionListeners connectionListeners) {
        return Stream.generate(() -> serverAddress).map(address -> this.singleConnection((InetSocketAddress)address, connectionListeners)).limit(connections).collect(Collectors.toList());
    }
}

