/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.core.metadata.TarantoolFieldMetadataImpl;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public final class ArrayValueToSpaceFormatConverter
implements ValueConverter<ArrayValue, Map<String, TarantoolFieldMetadata>> {
    private static final StringValue FORMAT_FIELD_NAME = new ImmutableStringValueImpl("name");
    private static final StringValue FORMAT_FIELD_TYPE = new ImmutableStringValueImpl("type");
    private static final StringValue FORMAT_FIELD_IS_NULLABLE = new ImmutableStringValueImpl("is_nullable");
    private static final ArrayValueToSpaceFormatConverter instance = new ArrayValueToSpaceFormatConverter();

    private ArrayValueToSpaceFormatConverter() {
    }

    @Override
    public Map<String, TarantoolFieldMetadata> fromValue(ArrayValue format) {
        LinkedHashMap<String, TarantoolFieldMetadata> spaceFormatMetadata = new LinkedHashMap<String, TarantoolFieldMetadata>();
        int fieldPosition = 0;
        for (Value fieldValueMetadata : format) {
            Map fieldMap = fieldValueMetadata.asMapValue().map();
            Optional isNullable = Optional.ofNullable(fieldMap.get(FORMAT_FIELD_IS_NULLABLE));
            spaceFormatMetadata.put(((Value)fieldMap.get(FORMAT_FIELD_NAME)).toString(), new TarantoolFieldMetadataImpl(((Value)fieldMap.get(FORMAT_FIELD_NAME)).asStringValue().asString(), ((Value)fieldMap.get(FORMAT_FIELD_TYPE)).asStringValue().asString(), fieldPosition, isNullable.isPresent() && ((Value)isNullable.get()).asBooleanValue().getBoolean()));
            ++fieldPosition;
        }
        return spaceFormatMetadata;
    }

    public static ArrayValueToSpaceFormatConverter getInstance() {
        return instance;
    }
}

