/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.core.TarantoolResultFactory;
import io.tarantool.driver.core.metadata.CRUDResponseToTarantoolSpaceMetadataConverter;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.converters.value.ArrayValueToTarantoolTupleConverter;
import java.util.Map;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class RowsMetadataToTarantoolTupleResultConverter
implements ValueConverter<MapValue, TarantoolResult<TarantoolTuple>> {
    private static final long serialVersionUID = -5228606294087295535L;
    protected static final StringValue RESULT_META = ValueFactory.newString((String)"metadata");
    protected static final StringValue RESULT_ROWS = ValueFactory.newString((String)"rows");
    protected static final CRUDResponseToTarantoolSpaceMetadataConverter spaceMetadataConverter = CRUDResponseToTarantoolSpaceMetadataConverter.getInstance();
    private final ArrayValueToTarantoolTupleConverter tupleConverter;
    private final TarantoolResultFactory tarantoolResultFactory;

    public RowsMetadataToTarantoolTupleResultConverter(ArrayValueToTarantoolTupleConverter tupleConverter) {
        this.tupleConverter = tupleConverter;
        this.tarantoolResultFactory = TarantoolResultFactory.getInstance();
    }

    @Override
    public TarantoolResult<TarantoolTuple> fromValue(MapValue value) {
        Map tupleMap = value.asMapValue().map();
        ArrayValue rawTuples = ((Value)tupleMap.get(RESULT_ROWS)).asArrayValue();
        ArrayValue rawMetadata = ((Value)tupleMap.get(RESULT_META)).asArrayValue();
        TarantoolSpaceMetadata parsedMetadata = spaceMetadataConverter.fromValue(rawMetadata);
        return this.tarantoolResultFactory.createTarantoolTupleResultImpl(rawTuples, parsedMetadata, this.tupleConverter);
    }

    @Override
    public boolean canConvertValue(MapValue value) {
        Map tupleMap = value.asMapValue().map();
        if (!RowsMetadataToTarantoolTupleResultConverter.hasRowsAndMetadata(tupleMap)) {
            return false;
        }
        return ((Value)tupleMap.get(RESULT_ROWS)).isArrayValue() && ((Value)tupleMap.get(RESULT_META)).isArrayValue();
    }

    static boolean hasRowsAndMetadata(Map<Value, Value> valueMap) {
        return valueMap.containsKey(RESULT_META) && valueMap.containsKey(RESULT_ROWS);
    }
}

