/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.proxy;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.space.options.Options;
import io.tarantool.driver.core.proxy.ProxyOperation;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import java.util.List;
import java.util.concurrent.CompletableFuture;

abstract class AbstractProxyOperation<T>
implements ProxyOperation<T> {
    protected final TarantoolCallOperations client;
    protected final String functionName;
    protected final List<?> arguments;
    private final MessagePackObjectMapper argumentsMapper;
    protected final CallResultMapper<T, SingleValueCallResult<T>> resultMapper;

    AbstractProxyOperation(TarantoolCallOperations client, String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) {
        this.client = client;
        this.argumentsMapper = argumentsMapper;
        this.arguments = arguments;
        this.functionName = functionName;
        this.resultMapper = resultMapper;
    }

    public TarantoolCallOperations getClient() {
        return this.client;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<?> getArguments() {
        return this.arguments;
    }

    public CallResultMapper<T, SingleValueCallResult<T>> getResultMapper() {
        return this.resultMapper;
    }

    @Override
    public CompletableFuture<T> execute() {
        return this.client.callForSingleResult(this.functionName, this.arguments, this.argumentsMapper, this.resultMapper);
    }

    static abstract class GenericOperationsBuilder<T, O extends Options, B extends GenericOperationsBuilder<T, O, B>> {
        protected TarantoolCallOperations client;
        protected String spaceName;
        protected String functionName;
        protected MessagePackObjectMapper argumentsMapper;
        protected CallResultMapper<T, SingleValueCallResult<T>> resultMapper;
        protected O options;

        GenericOperationsBuilder() {
        }

        abstract B self();

        public B withClient(TarantoolCallOperations client) {
            this.client = client;
            return this.self();
        }

        public B withSpaceName(String spaceName) {
            this.spaceName = spaceName;
            return this.self();
        }

        public B withFunctionName(String functionName) {
            this.functionName = functionName;
            return this.self();
        }

        public B withArgumentsMapper(MessagePackObjectMapper objectMapper) {
            this.argumentsMapper = objectMapper;
            return this.self();
        }

        public B withResultMapper(CallResultMapper<T, SingleValueCallResult<T>> resultMapper) {
            this.resultMapper = resultMapper;
            return this.self();
        }

        public B withOptions(O options) {
            this.options = options;
            return this.self();
        }
    }
}

