/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.proxy;

import io.tarantool.driver.core.proxy.CRUDReturnOptions;
import java.util.Optional;

final class CRUDBatchOptions
extends CRUDReturnOptions {
    public static final String BATCH_STOP_ON_ERROR = "stop_on_error";
    public static final String BATCH_ROLLBACK_ON_ERROR = "rollback_on_error";

    private <T extends AbstractBuilder<T>> CRUDBatchOptions(AbstractBuilder<T> builder) {
        super(builder);
        this.addOption(BATCH_STOP_ON_ERROR, ((AbstractBuilder)builder).stopOnError);
        this.addOption(BATCH_ROLLBACK_ON_ERROR, ((AbstractBuilder)builder).rollbackOnError);
    }

    protected static final class Builder
    extends AbstractBuilder<Builder> {
        protected Builder() {
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public CRUDBatchOptions build() {
            return new CRUDBatchOptions(this);
        }
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends CRUDReturnOptions.AbstractBuilder<CRUDBatchOptions, B> {
        private Optional<Boolean> stopOnError = Optional.empty();
        private Optional<Boolean> rollbackOnError = Optional.empty();

        protected AbstractBuilder() {
        }

        public B withStopOnError(Optional<Boolean> stopOnError) {
            this.stopOnError = stopOnError;
            return (B)((AbstractBuilder)this.self());
        }

        public B withRollbackOnError(Optional<Boolean> rollbackOnError) {
            this.rollbackOnError = rollbackOnError;
            return (B)((AbstractBuilder)this.self());
        }
    }
}

