/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.proxy;

import io.tarantool.driver.core.proxy.CRUDBucketIdOptions;
import io.tarantool.driver.protocol.Packable;
import java.util.List;
import java.util.Optional;

final class CRUDSelectOptions
extends CRUDBucketIdOptions {
    public static final String SELECT_LIMIT = "first";
    public static final String SELECT_AFTER = "after";
    public static final String SELECT_BATCH_SIZE = "batch_size";
    public static final String FIELDS = "fields";

    private <B extends AbstractBuilder<B>> CRUDSelectOptions(AbstractBuilder<B> builder) {
        super(builder);
        this.addOption(SELECT_LIMIT, ((AbstractBuilder)builder).selectLimit);
        this.addOption(SELECT_AFTER, ((AbstractBuilder)builder).after);
        this.addOption(SELECT_BATCH_SIZE, ((AbstractBuilder)builder).selectBatchSize);
        this.addOption(FIELDS, ((AbstractBuilder)builder).fields);
    }

    protected static final class Builder
    extends AbstractBuilder<Builder> {
        protected Builder() {
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public CRUDSelectOptions build() {
            return new CRUDSelectOptions(this);
        }
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends CRUDBucketIdOptions.AbstractBuilder<CRUDSelectOptions, B> {
        private Optional<Long> selectLimit = Optional.empty();
        private Optional<Packable> after = Optional.empty();
        private Optional<Integer> selectBatchSize = Optional.empty();
        private Optional<List> fields = Optional.empty();

        protected AbstractBuilder() {
        }

        public B withSelectLimit(Optional<Long> selectLimit) {
            this.selectLimit = selectLimit;
            return (B)((AbstractBuilder)this.self());
        }

        public B withSelectBatchSize(Optional<Integer> selectBatchSize) {
            this.selectBatchSize = selectBatchSize;
            return (B)((AbstractBuilder)this.self());
        }

        public B withSelectAfter(Optional<Packable> startTuple) {
            this.after = startTuple;
            return (B)((AbstractBuilder)this.self());
        }

        public B withFields(Optional<List> fields) {
            this.fields = fields;
            return (B)((AbstractBuilder)this.self());
        }
    }
}

