/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.space;

import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolVoidResult;
import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.tuple.operations.TupleOperation;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.core.connection.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolSpaceFieldNotFoundException;
import io.tarantool.driver.exceptions.TarantoolSpaceOperationException;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.requests.TarantoolCallRequest;
import io.tarantool.driver.protocol.requests.TarantoolDeleteRequest;
import io.tarantool.driver.protocol.requests.TarantoolInsertRequest;
import io.tarantool.driver.protocol.requests.TarantoolReplaceRequest;
import io.tarantool.driver.protocol.requests.TarantoolSelectRequest;
import io.tarantool.driver.protocol.requests.TarantoolUpdateRequest;
import io.tarantool.driver.protocol.requests.TarantoolUpsertRequest;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public abstract class TarantoolSpace<T extends Packable, R extends Collection<T>>
implements TarantoolSpaceOperations<T, R> {
    private final int spaceId;
    private final TarantoolClientConfig config;
    private final TarantoolConnectionManager connectionManager;
    private final TarantoolSpaceMetadata spaceMetadata;
    private final TarantoolMetadataOperations metadataOperations;

    public TarantoolSpace(TarantoolClientConfig config, TarantoolConnectionManager connectionManager, TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        this.spaceId = spaceMetadata.getSpaceId();
        this.config = config;
        this.connectionManager = connectionManager;
        this.spaceMetadata = spaceMetadata;
        this.metadataOperations = metadataOperations;
    }

    @Override
    public CompletableFuture<R> delete(Conditions conditions) throws TarantoolClientException {
        return this.delete(conditions, this.arrayTupleResultMapper());
    }

    private CompletableFuture<R> delete(Conditions conditions, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
            TarantoolDeleteRequest request = new TarantoolDeleteRequest.Builder().withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withKeyValues(indexQuery.getKeyValues()).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<R> insert(T tuple) throws TarantoolClientException {
        return this.insert(tuple, this.arrayTupleResultMapper());
    }

    @Override
    public CompletableFuture<R> insertMany(Collection<T> tuples) throws TarantoolClientException {
        throw new UnsupportedOperationException("Standalone node API does not support inserting several tuples at once yet");
    }

    private CompletableFuture<R> insert(T tuple, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolInsertRequest request = new TarantoolInsertRequest.Builder().withSpaceId(this.spaceId).withTuple((Packable)tuple).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<R> replace(T tuple) throws TarantoolClientException {
        return this.replace(tuple, this.arrayTupleResultMapper());
    }

    @Override
    public CompletableFuture<R> replaceMany(Collection<T> tuples) throws TarantoolClientException {
        throw new UnsupportedOperationException("Standalone node API does not support replacing several tuples at once yet");
    }

    private CompletableFuture<R> replace(T tuple, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolReplaceRequest request = new TarantoolReplaceRequest.Builder().withSpaceId(this.spaceId).withTuple((Packable)tuple).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<R> select(Conditions conditions) throws TarantoolClientException {
        return this.select(conditions, this.arrayTupleResultMapper());
    }

    private CompletableFuture<R> select(Conditions conditions, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
            TarantoolSelectRequest request = new TarantoolSelectRequest.Builder().withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withIteratorType(indexQuery.getIteratorType()).withKeyValues(indexQuery.getKeyValues()).withLimit(conditions.getLimit()).withOffset(conditions.getOffset()).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<R> update(Conditions conditions, T tuple) {
        return this.update(conditions, this.makeOperationsFromTuple(tuple), this.arrayTupleResultMapper());
    }

    protected abstract TupleOperations makeOperationsFromTuple(T var1);

    @Override
    public CompletableFuture<R> update(Conditions conditions, TupleOperations operations) {
        return this.update(conditions, operations, this.arrayTupleResultMapper());
    }

    private CompletableFuture<R> update(Conditions conditions, TupleOperations operations, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
            Optional<TarantoolIndexMetadata> indexMetadata = this.metadataOperations.getIndexById(this.spaceId, indexQuery.getIndexId());
            if (!indexMetadata.isPresent() || !indexMetadata.get().isUnique()) {
                throw new TarantoolSpaceOperationException("Index must be primary or unique for update operation");
            }
            TarantoolUpdateRequest request = new TarantoolUpdateRequest.Builder().withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withKeyValues(indexQuery.getKeyValues()).withTupleOperations(this.fillFieldIndexFromMetadata(operations)).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<R> upsert(Conditions conditions, T tuple, TupleOperations operations) {
        return this.upsert(conditions, tuple, operations, this.arrayTupleResultMapper());
    }

    private CompletableFuture<R> upsert(Conditions conditions, T tuple, TupleOperations operations, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
            TarantoolUpsertRequest request = new TarantoolUpsertRequest.Builder().withSpaceId(this.spaceId).withKeyValues(indexQuery.getKeyValues()).withTuple((Packable)tuple).withTupleOperations(this.fillFieldIndexFromMetadata(operations)).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<Void> truncate() throws TarantoolClientException {
        return this.truncate(this.arrayTupleResultMapper());
    }

    private CompletableFuture<Void> truncate(MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            String spaceName = this.spaceMetadata.getSpaceName();
            TarantoolCallRequest request = new TarantoolCallRequest.Builder().withFunctionName("box.space." + spaceName + ":truncate").build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper).thenApply(v -> (Void)TarantoolVoidResult.INSTANCE.value());
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    protected abstract MessagePackValueMapper arrayTupleResultMapper();

    private CompletableFuture<R> sendRequest(TarantoolRequest request, MessagePackValueMapper resultMapper) {
        return this.connectionManager.getConnection().thenCompose(c -> c.sendRequest(request, resultMapper));
    }

    @Override
    public TarantoolSpaceMetadata getMetadata() {
        return this.spaceMetadata;
    }

    public String toString() {
        return String.format("StandaloneTarantoolSpace %s [%d]", this.spaceMetadata.getSpaceName(), this.spaceMetadata.getSpaceId());
    }

    private List<TupleOperation> fillFieldIndexFromMetadata(TupleOperations operations) {
        return operations.asList().stream().map(operation -> {
            if (operation.getFieldIndex() == null) {
                String fieldName = operation.getFieldName();
                int fieldMetadataIndex = this.spaceMetadata.getFieldByName(fieldName).orElseThrow(() -> new TarantoolSpaceFieldNotFoundException(fieldName)).getFieldPosition();
                return operation.cloneWithIndex(fieldMetadataIndex);
            }
            return operation;
        }).collect(Collectors.toList());
    }
}

