/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.object;

import io.tarantool.driver.mappers.converters.ObjectConverter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.ValueFactory;

public class DefaultInstantToExtensionValueConverter
implements ObjectConverter<Instant, ExtensionValue> {
    private static final long serialVersionUID = 20221025L;
    private static final byte DATETIME_TYPE = 4;

    private byte[] toBytes(Instant value) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(value.getEpochSecond());
        buffer.putInt(value.getNano());
        return buffer.array();
    }

    @Override
    public ExtensionValue toValue(Instant object) {
        return ValueFactory.newExtension((byte)4, (byte[])this.toBytes(object));
    }
}

