/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.value.defaults;

import io.tarantool.driver.mappers.MessagePackValueMapperException;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ExtensionValue;

public class DefaultExtensionValueToBigDecimalConverter
implements ValueConverter<ExtensionValue, BigDecimal> {
    private static final long serialVersionUID = 20220418L;
    private static final byte DECIMAL_TYPE = 1;
    private static final int DECIMAL_MAX_DIGITS = 38;
    private static final byte DECIMAL_MINUS = 13;
    private static final byte DECIMAL_MINUS_ALT = 11;

    private BigDecimal fromBytes(byte[] data) throws IOException {
        int i;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((ByteBuffer)buffer);
        int scale = unpacker.unpackInt();
        unpacker.close();
        if (scale > 38 || scale < -38) {
            throw new IOException(String.format("Scales with absolute value greater than %d are not supported", 38));
        }
        if (!buffer.hasRemaining()) {
            throw new IOException("Not enough bytes in the packed data");
        }
        int len = data.length;
        int signum = data[len - 1] & 0xF;
        if (signum == 13 || signum == 11) {
            signum = -1;
        } else {
            if (signum <= 9) {
                throw new IOException("The sign nibble has wrong value");
            }
            signum = 1;
        }
        for (i = buffer.position() + 1; i < len && data[i] == 0; ++i) {
        }
        if (len == i && (data[len - 1] & 0xF0) == 0) {
            return BigDecimal.ZERO;
        }
        int digitsNum = len - i << 1;
        char digit = (char)((data[len - 1] & 0xF0) >>> 4);
        if (digit > '\t') {
            throw new IOException(String.format("Invalid digit at position %d", digitsNum - 1));
        }
        char[] digits = new char[digitsNum];
        int pos = 2 * (len - i) - 1;
        digits[pos--] = Character.forDigit(digit, 10);
        for (int j = len - 2; j >= i; --j) {
            digit = (char)(data[j] & 0xF);
            if (digit > '\t') {
                throw new IOException(String.format("Invalid digit at position %d", pos));
            }
            digits[pos--] = Character.forDigit(digit, 10);
            digit = (char)((data[j] & 0xF0) >>> 4);
            if (digit > '\t') {
                throw new IOException(String.format("Invalid digit at position %d", pos - 1));
            }
            digits[pos--] = Character.forDigit(digit, 10);
        }
        StringBuilder sb = new StringBuilder(len - i + 1);
        if (signum < 0) {
            sb.append('-');
        }
        pos = 0;
        while (digits[pos] == '\u0000') {
            ++pos;
        }
        while (pos < digits.length) {
            sb.append(digits[pos]);
            ++pos;
        }
        return new BigDecimal(new BigInteger(sb.toString()), scale);
    }

    @Override
    public BigDecimal fromValue(ExtensionValue value) {
        try {
            return this.fromBytes(value.getData());
        }
        catch (IOException e) {
            throw new MessagePackValueMapperException(String.format("Failed to unpack BigDecimal from MessagePack entity %s", value), e);
        }
    }

    @Override
    public boolean canConvertValue(ExtensionValue value) {
        return value.getType() == 1;
    }
}

