/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.factories;

import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.AbstractResultMapper;
import io.tarantool.driver.mappers.InterfaceParameterClassNotFoundException;
import io.tarantool.driver.mappers.MapperReflectionUtils;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.converters.ValueConverterWithInputTypeWrapper;
import java.util.List;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;

public abstract class AbstractResultMapperFactory<O, T extends AbstractResultMapper<? extends O>> {
    protected abstract T createMapper(MessagePackValueMapper var1, ValueType var2, ValueConverter<? extends Value, ? extends O> var3, Class<? extends O> var4);

    protected abstract T createMapper(MessagePackValueMapper var1, ValueType var2, ValueConverter<? extends Value, ? extends O> var3);

    protected abstract T createMapper(MessagePackValueMapper var1, List<ValueConverterWithInputTypeWrapper<O>> var2, Class<? extends O> var3);

    protected abstract T createMapper(MessagePackValueMapper var1, List<ValueConverterWithInputTypeWrapper<O>> var2);

    public T withConverter(MessagePackValueMapper valueMapper, ValueConverter<? extends Value, ? extends O> valueConverter) {
        return this.withConverter(valueMapper, ValueType.ARRAY, valueConverter);
    }

    public T withConverter(MessagePackValueMapper valueMapper, ValueType valueType, ValueConverter<? extends Value, ? extends O> valueConverter) {
        try {
            return this.withConverter(valueMapper, valueType, valueConverter, MapperReflectionUtils.getConverterTargetType(valueConverter));
        }
        catch (InterfaceParameterClassNotFoundException e) {
            throw new TarantoolClientException(e);
        }
    }

    public T withConverterWithoutTargetClass(MessagePackValueMapper valueMapper, ValueType valueType, ValueConverter<? extends Value, ? extends O> valueConverter) {
        return this.createMapper(valueMapper, valueType, valueConverter);
    }

    public T withConverter(MessagePackValueMapper valueMapper, ValueConverter<? extends Value, ? extends O> valueConverter, Class<? extends O> resultClass) {
        return this.withConverter(valueMapper, ValueType.ARRAY, valueConverter, resultClass);
    }

    public T withConverter(MessagePackValueMapper valueMapper, ValueType valueType, ValueConverter<? extends Value, ? extends O> valueConverter, Class<? extends O> resultClass) {
        return this.createMapper(valueMapper, valueType, valueConverter, resultClass);
    }

    public T withConverters(MessagePackValueMapper valueMapper, List<ValueConverterWithInputTypeWrapper<O>> converters) {
        if (converters.size() < 1) {
            throw new TarantoolClientException("Empty converters list");
        }
        try {
            return this.withConverters(valueMapper, converters, MapperReflectionUtils.getConverterTargetType(converters.get(0).getValueConverter()));
        }
        catch (InterfaceParameterClassNotFoundException e) {
            throw new TarantoolClientException(e);
        }
    }

    public T withConverters(MessagePackValueMapper valueMapper, List<ValueConverterWithInputTypeWrapper<O>> converters, Class<? extends O> resultClass) {
        return this.createMapper(valueMapper, converters, resultClass);
    }

    public T withConverterWithoutTargetClass(MessagePackValueMapper valueMapper, List<ValueConverterWithInputTypeWrapper<O>> converters) {
        return this.createMapper(valueMapper, converters);
    }
}

