/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.retry;

import io.tarantool.driver.api.retry.RetryingAsyncOperation;
import io.tarantool.driver.utils.Assert;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

@FunctionalInterface
public interface RequestRetryPolicy {
    public static final int DEFAULT_DELAY = 500;
    public static final long DEFAULT_REQUEST_TIMEOUT = TimeUnit.HOURS.toMillis(1L);

    public boolean canRetryRequest(Throwable var1);

    default public long getRequestTimeout() {
        return DEFAULT_REQUEST_TIMEOUT;
    }

    default public long getDelay() {
        return 500L;
    }

    default public Throwable getPolicyException(Throwable ex) {
        return ex;
    }

    default public <T> CompletableFuture<T> wrapOperation(Supplier<CompletableFuture<T>> operation, Executor executor) {
        Assert.notNull(operation, "Operation must not be null");
        Assert.notNull(executor, "Executor must not be null");
        CompletableFuture resultFuture = new CompletableFuture();
        AtomicReference<Throwable> lastExceptionWrapper = new AtomicReference<Throwable>();
        CompletableFuture.runAsync(new RetryingAsyncOperation<T>(this, operation, resultFuture, lastExceptionWrapper), executor).exceptionally(ex -> {
            resultFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return resultFuture;
    }
}

