/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.cluster;

import io.tarantool.driver.api.TarantoolClusterAddressProvider;
import io.tarantool.driver.api.TarantoolServerAddress;
import io.tarantool.driver.cluster.TarantoolClusterDiscoveryConfig;
import io.tarantool.driver.core.TarantoolDaemonThreadFactory;
import io.tarantool.driver.exceptions.TarantoolClientException;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractDiscoveryClusterAddressProvider
implements TarantoolClusterAddressProvider {
    private final TarantoolClusterDiscoveryConfig discoveryConfig;
    private final ScheduledExecutorService scheduledExecutorService;
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final AtomicReference<Collection<TarantoolServerAddress>> addressesHolder = new AtomicReference();
    private final AtomicReference<Runnable> refreshCallback;

    public AbstractDiscoveryClusterAddressProvider(TarantoolClusterDiscoveryConfig discoveryConfig) {
        this.discoveryConfig = discoveryConfig;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new TarantoolDaemonThreadFactory("tarantool-discovery"));
        this.refreshCallback = new AtomicReference<Runnable>(() -> {});
    }

    protected void startDiscoveryTask() throws TarantoolClientException {
        Runnable discoveryTask = () -> {
            try {
                this.setAddresses(this.discoverAddresses());
            }
            finally {
                if (this.initLatch.getCount() > 0L) {
                    this.initLatch.countDown();
                }
            }
            this.refreshCallback.get().run();
        };
        this.scheduledExecutorService.scheduleWithFixedDelay(discoveryTask, 0L, this.discoveryConfig.getServiceDiscoveryDelay(), TimeUnit.MILLISECONDS);
    }

    protected TarantoolClusterDiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    protected ScheduledExecutorService getExecutorService() {
        return this.scheduledExecutorService;
    }

    protected abstract Collection<TarantoolServerAddress> discoverAddresses();

    private void setAddresses(Collection<TarantoolServerAddress> addresses) {
        this.addressesHolder.set(addresses);
    }

    @Override
    public Collection<TarantoolServerAddress> getAddresses() {
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException("Interrupted while waiting for cluster addresses discovery");
        }
        return this.addressesHolder.get();
    }

    @Override
    public void setRefreshCallback(Runnable runnable) {
        this.refreshCallback.set(runnable);
    }

    @Override
    public void close() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }
}

