/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.MultiValueCallResult;
import io.tarantool.driver.exceptions.TarantoolFunctionCallException;
import io.tarantool.driver.exceptions.errors.TarantoolErrorsParser;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.util.List;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class MultiValueCallResultImpl<T, R extends List<T>>
implements MultiValueCallResult<T, R> {
    private final R value;

    public MultiValueCallResultImpl(Value result, ValueConverter<ArrayValue, R> valueConverter) {
        if (result == null) {
            throw new TarantoolFunctionCallException("Function call result is null");
        }
        if (!result.isArrayValue()) {
            throw new TarantoolFunctionCallException("Function call result is not a MessagePack array");
        }
        ArrayValue resultArray = result.asArrayValue();
        if (resultArray.size() == 2 && resultArray.get(0).isNilValue() && !resultArray.get(1).isNilValue()) {
            throw TarantoolErrorsParser.parse(resultArray.get(1));
        }
        this.value = (List)valueConverter.fromValue(result.asArrayValue());
    }

    public MultiValueCallResultImpl(Value result, MessagePackValueMapper valueMapper) {
        if (result == null) {
            throw new TarantoolFunctionCallException("Function call result is null");
        }
        if (!result.isArrayValue()) {
            throw new TarantoolFunctionCallException("Function call result is not a MessagePack array");
        }
        ArrayValue resultArray = result.asArrayValue();
        if (resultArray.size() == 2 && resultArray.get(0).isNilValue() && !resultArray.get(1).isNilValue()) {
            throw TarantoolErrorsParser.parse(resultArray.get(1));
        }
        this.value = (List)valueMapper.fromValue(result.asArrayValue());
    }

    @Override
    public R value() {
        return this.value;
    }
}

