/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.conditions;

import io.tarantool.driver.api.conditions.PositionField;
import io.tarantool.driver.api.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.exceptions.TarantoolFieldNotFoundException;
import io.tarantool.driver.utils.Assert;
import java.util.Objects;
import java.util.Optional;

public class PositionFieldImpl
implements PositionField {
    private static final long serialVersionUID = 20200708L;
    private final int position;

    public PositionFieldImpl(int position) {
        Assert.state(position >= 0, "Field position must be greater or equal 0");
        this.position = position;
    }

    @Override
    public TarantoolFieldMetadata metadata(TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        Optional<TarantoolFieldMetadata> fieldMetadata = spaceMetadata.getFieldByPosition(this.position);
        if (!fieldMetadata.isPresent()) {
            throw new TarantoolFieldNotFoundException(this.position, spaceMetadata);
        }
        return fieldMetadata.get();
    }

    @Override
    public Integer toIdentifier() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionFieldImpl that = (PositionFieldImpl)o;
        return this.position == that.position;
    }

    public int hashCode() {
        return Objects.hash(this.position);
    }
}

