/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.proxy;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.space.options.Options;
import io.tarantool.driver.api.space.options.Self;
import io.tarantool.driver.core.proxy.BuilderOptions;
import io.tarantool.driver.core.proxy.ProxyOperation;
import io.tarantool.driver.core.proxy.enums.ProxyOperationArgument;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import java.util.Collection;
import java.util.EnumMap;
import java.util.concurrent.CompletableFuture;

abstract class AbstractProxyOperation<T>
implements ProxyOperation<T> {
    protected final TarantoolCallOperations client;
    protected final String functionName;
    protected final Collection<?> arguments;
    protected final CallResultMapper<T, SingleValueCallResult<T>> resultMapper;
    private final MessagePackObjectMapper argumentsMapper;

    AbstractProxyOperation(TarantoolCallOperations client, String functionName, Collection<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) {
        this.client = client;
        this.argumentsMapper = argumentsMapper;
        this.arguments = arguments;
        this.functionName = functionName;
        this.resultMapper = resultMapper;
    }

    public TarantoolCallOperations getClient() {
        return this.client;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Collection<?> getArguments() {
        return this.arguments;
    }

    public CallResultMapper<T, SingleValueCallResult<T>> getResultMapper() {
        return this.resultMapper;
    }

    @Override
    public CompletableFuture<T> execute() {
        return this.client.callForSingleResult(this.functionName, this.arguments, this.argumentsMapper, this.resultMapper);
    }

    static abstract class GenericOperationsBuilder<T, O extends Options, B extends GenericOperationsBuilder<T, O, B>>
    implements BuilderOptions,
    Self<B> {
        protected TarantoolCallOperations client;
        protected String functionName;
        protected MessagePackObjectMapper argumentsMapper;
        protected CallResultMapper<T, SingleValueCallResult<T>> resultMapper;
        protected EnumMap<ProxyOperationArgument, Object> arguments = new EnumMap(ProxyOperationArgument.class);

        GenericOperationsBuilder() {
        }

        @Override
        public void addArgument(ProxyOperationArgument optionName, Object option) {
            this.arguments.put(optionName, option);
        }

        public B withClient(TarantoolCallOperations client) {
            this.client = client;
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withSpaceName(String spaceName) {
            this.addArgument(ProxyOperationArgument.SPACE_NAME, spaceName);
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withFunctionName(String functionName) {
            this.functionName = functionName;
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withArgumentsMapper(MessagePackObjectMapper objectMapper) {
            this.argumentsMapper = objectMapper;
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withResultMapper(CallResultMapper<T, SingleValueCallResult<T>> resultMapper) {
            this.resultMapper = resultMapper;
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withOptions(O options) {
            this.addArgument(ProxyOperationArgument.OPTIONS, options.asMap());
            return (B)((GenericOperationsBuilder)this.self());
        }
    }
}

