/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.proxy;

import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.TarantoolVoidResult;
import io.tarantool.driver.api.space.options.crud.OperationWithTimeoutOptions;
import io.tarantool.driver.core.proxy.AbstractProxyOperation;
import io.tarantool.driver.core.proxy.ProxyOperation;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public final class TruncateProxyOperation
implements ProxyOperation<Void> {
    private final TarantoolCallOperations client;
    private final String functionName;
    private final Collection<?> arguments;

    private TruncateProxyOperation(TarantoolCallOperations client, String functionName, Collection<?> arguments) {
        this.client = client;
        this.arguments = arguments;
        this.functionName = functionName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TarantoolCallOperations getClient() {
        return this.client;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Collection<?> getArguments() {
        return this.arguments;
    }

    @Override
    public CompletableFuture<Void> execute() {
        return this.client.callForSingleResult(this.functionName, this.arguments, Boolean.class).thenApply(v -> (Void)TarantoolVoidResult.INSTANCE.value());
    }

    public static final class Builder
    extends AbstractProxyOperation.GenericOperationsBuilder<Void, OperationWithTimeoutOptions<?>, Builder> {
        @Override
        public Builder self() {
            return this;
        }

        public TruncateProxyOperation build() {
            return new TruncateProxyOperation(this.client, this.functionName, this.arguments.values());
        }
    }
}

