/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.exceptions.errors;

import io.tarantool.driver.exceptions.errors.ErrorKey;
import java.util.Map;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;

class ErrorMessageBuilder {
    private final StringBuilder stringBuilder;
    private final Map<Value, Value> values;
    private final ErrorKey[] keys;

    ErrorMessageBuilder(String startsWith, ErrorKey[] keys, Map<Value, Value> values) {
        this.stringBuilder = new StringBuilder(startsWith);
        this.values = values;
        this.keys = keys;
    }

    String build() {
        for (ErrorKey key : this.keys) {
            String s;
            StringValue stringValue = key.getMsgPackKey();
            String string = s = this.values.containsKey(stringValue) ? this.values.get(stringValue).toString() : null;
            if (s == null || s.length() == 0) continue;
            this.stringBuilder.append("\n").append(key.getKey().toLowerCase()).append(": ").append(s);
        }
        return this.stringBuilder.toString();
    }
}

