/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.tarantool.driver.TarantoolVersionHolder;
import io.tarantool.driver.auth.TarantoolAuthenticator;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.exceptions.TarantoolBadCredentialsException;
import io.tarantool.driver.handlers.TarantoolAuthenticationResponseHandler;
import io.tarantool.driver.protocol.requests.TarantoolAuthRequest;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarantoolAuthenticationHandler<S extends TarantoolCredentials, T extends TarantoolAuthenticator<S>>
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(TarantoolAuthenticationHandler.class);
    private static final int VERSION_LENGTH = 64;
    private static final int SALT_LENGTH = 44;
    private static final int GREETING_LENGTH = 128;
    private final TarantoolVersionHolder versionHolder;
    private final S credentials;
    private final T authenticator;
    private final CompletableFuture<Channel> connectionFuture;

    public TarantoolAuthenticationHandler(CompletableFuture<Channel> connectionFuture, TarantoolVersionHolder versionHolder, S credentials, T authenticator) {
        this.connectionFuture = connectionFuture;
        this.versionHolder = versionHolder;
        this.credentials = credentials;
        this.authenticator = authenticator;
    }

    public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (in.readableBytes() < 128) {
            return;
        }
        byte[] array = new byte[64];
        in.readBytes(array);
        String greeting = new String(array);
        this.versionHolder.readVersion(greeting);
        if (this.authenticator.canAuthenticateWith(this.credentials)) {
            array = new byte[44];
            in.readBytes(array).skipBytes(20);
            byte[] authData = this.authenticator.prepareUserAuthData(array, this.credentials);
            TarantoolAuthRequest authRequest = new TarantoolAuthRequest.Builder().withUsername(this.credentials.getUsername()).withAuthData(this.authenticator.getMechanism(), authData).build();
            ctx.channel().writeAndFlush((Object)authRequest).addListener(f -> {
                if (!f.isSuccess()) {
                    this.connectionFuture.completeExceptionally(new RuntimeException("Failed to write the auth request to channel", f.cause()));
                }
            });
        } else if (this.authenticator.canSkipAuth(this.credentials)) {
            log.info("Cannot authenticate with provided credentials, skipping authentication");
            this.connectionFuture.complete(ctx.channel());
            ctx.pipeline().remove(TarantoolAuthenticationResponseHandler.class);
        } else {
            throw new TarantoolBadCredentialsException();
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.connectionFuture.completeExceptionally(cause);
    }
}

