/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.value;

import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.core.TarantoolResultFactory;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.converters.value.ArrayValueToTarantoolTupleConverter;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class ArrayValueToTarantoolTupleResultConverter
implements ValueConverter<ArrayValue, TarantoolResult<TarantoolTuple>> {
    private static final long serialVersionUID = -1348387430063097175L;
    private final ArrayValueToTarantoolTupleConverter tupleConverter;
    private final TarantoolResultFactory tarantoolResultFactory;

    public ArrayValueToTarantoolTupleResultConverter(ArrayValueToTarantoolTupleConverter tupleConverter) {
        this.tupleConverter = tupleConverter;
        this.tarantoolResultFactory = TarantoolResultFactory.getInstance();
    }

    @Override
    public TarantoolResult<TarantoolTuple> fromValue(ArrayValue value) {
        return this.tarantoolResultFactory.createTarantoolTupleResultImpl((Value)value, this.tupleConverter);
    }

    @Override
    public boolean canConvertValue(ArrayValue value) {
        return value.size() == 0 || value.get(0).isArrayValue();
    }
}

