/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.value.defaults;

import io.tarantool.driver.mappers.converters.ValueConverter;
import org.msgpack.value.FloatValue;

public class DefaultFloatValueToFloatConverter
implements ValueConverter<FloatValue, Float> {
    private static final long serialVersionUID = 20220418L;

    @Override
    public Float fromValue(FloatValue value) {
        return Float.valueOf(value.toFloat());
    }

    @Override
    public boolean canConvertValue(FloatValue value) {
        double aDouble = value.toDouble();
        return aDouble <= 0.0 ? this.isInAcceptableRange(0.0 - aDouble) : this.isInAcceptableRange(aDouble);
    }

    private boolean isInAcceptableRange(double aDouble) {
        return (double)1.4E-45f <= aDouble && aDouble <= 3.4028234663852886E38 || aDouble == 0.0;
    }
}

