/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.api.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolIndexNotFoundException;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import java.util.Optional;

public class TarantoolIndexQueryFactory {
    private final TarantoolMetadataOperations metadataOperations;

    public TarantoolIndexQueryFactory(TarantoolMetadataOperations metadataOperations) {
        this.metadataOperations = metadataOperations;
    }

    public TarantoolIndexQuery primary() {
        return new TarantoolIndexQuery();
    }

    public TarantoolIndexQuery byName(int spaceId, String indexName) throws TarantoolClientException {
        Optional<TarantoolIndexMetadata> meta = this.metadataOperations.getIndexByName(spaceId, indexName);
        if (!meta.isPresent()) {
            throw new TarantoolIndexNotFoundException(spaceId, indexName);
        }
        return new TarantoolIndexQuery(meta.get().getIndexId());
    }

    public TarantoolIndexQuery byName(String spaceName, String indexName) throws TarantoolClientException {
        Optional<TarantoolIndexMetadata> meta = this.metadataOperations.getIndexByName(spaceName, indexName);
        if (!meta.isPresent()) {
            throw new TarantoolIndexNotFoundException(spaceName, indexName);
        }
        return new TarantoolIndexQuery(meta.get().getIndexId());
    }
}

