/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.AbstractTarantoolClient;
import io.tarantool.driver.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.TarantoolSingleAddressProvider;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.core.TarantoolConnectionFactory;
import io.tarantool.driver.core.TarantoolConnectionListeners;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.core.TarantoolConnectionSelectionStrategies;
import io.tarantool.driver.core.TarantoolSingleConnectionManager;
import io.tarantool.driver.utils.Assert;

public class StandaloneTarantoolClient
extends AbstractTarantoolClient {
    private final ConnectionSelectionStrategyFactory selectStrategyFactory;
    private final TarantoolSingleAddressProvider addressProvider;

    public StandaloneTarantoolClient() {
        this(new SimpleTarantoolCredentials());
    }

    public StandaloneTarantoolClient(TarantoolCredentials credentials) {
        this(credentials, new TarantoolServerAddress());
    }

    public StandaloneTarantoolClient(TarantoolCredentials credentials, String host, int port) {
        this(credentials, new TarantoolServerAddress(host, port));
    }

    public StandaloneTarantoolClient(TarantoolCredentials credentials, TarantoolServerAddress address) {
        this(TarantoolClientConfig.builder().withCredentials(credentials).build(), address);
    }

    public StandaloneTarantoolClient(TarantoolClientConfig config, TarantoolServerAddress address) {
        this(config, () -> address, TarantoolConnectionSelectionStrategies.RoundRobinStrategyFactory.INSTANCE);
    }

    public StandaloneTarantoolClient(TarantoolClientConfig config, TarantoolSingleAddressProvider addressProvider, ConnectionSelectionStrategyFactory selectStrategyFactory) {
        super(config);
        Assert.notNull(addressProvider, "Address provider must not be null");
        Assert.notNull(selectStrategyFactory, "Connection selection strategy factory must not be null");
        this.addressProvider = addressProvider;
        this.selectStrategyFactory = selectStrategyFactory;
    }

    @Override
    protected TarantoolConnectionManager connectionManager(TarantoolClientConfig config, TarantoolConnectionFactory connectionFactory, TarantoolConnectionListeners listeners) {
        return new TarantoolSingleConnectionManager(config, connectionFactory, this.selectStrategyFactory, listeners, this.addressProvider);
    }
}

