/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.conditions;

import io.tarantool.driver.api.conditions.Condition;
import io.tarantool.driver.api.conditions.FieldValueCondition;
import io.tarantool.driver.api.conditions.IdIndex;
import io.tarantool.driver.api.conditions.IndexValueCondition;
import io.tarantool.driver.api.conditions.NamedField;
import io.tarantool.driver.api.conditions.NamedIndex;
import io.tarantool.driver.api.conditions.Operator;
import io.tarantool.driver.api.conditions.PositionField;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.ObjectConverter;
import io.tarantool.driver.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolIndexPartMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import io.tarantool.driver.protocol.TarantoolIteratorType;
import io.tarantool.driver.utils.Assert;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public final class Conditions {
    private static final long MAX_LIMIT = 0xFFFFFFFFL;
    private static final long MAX_OFFSET = 0xFFFFFFFFL;
    private final List<Condition> conditions = new LinkedList<Condition>();
    private boolean descending;
    private long limit = 0xFFFFFFFFL;
    private long offset;
    private Packable startTuple;

    private Conditions(boolean descending) {
        this.descending = descending;
    }

    private Conditions(Condition condition) {
        this.conditions.add(condition);
    }

    private Conditions(long limit, long offset) {
        this.limit = limit;
        this.offset = offset;
    }

    private Conditions(Packable startTuple) {
        this.startTuple = startTuple;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public static Conditions descending() {
        return new Conditions(true);
    }

    public Conditions withDescending() {
        this.descending = true;
        return this;
    }

    public static Conditions ascending() {
        return new Conditions(false);
    }

    public Conditions withAscending() {
        return this;
    }

    public static Conditions any() {
        return Conditions.ascending();
    }

    public static Conditions limit(long limit) {
        Assert.state(limit >= 0L && limit <= 0xFFFFFFFFL, "Limit mast be a value between 0 and 0xffffffff");
        return new Conditions(limit, 0L);
    }

    public Conditions withLimit(long limit) {
        Assert.state(limit >= 0L && limit <= 0xFFFFFFFFL, "Limit mast be a value between 0 and 0xffffffff");
        this.limit = limit;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public static Conditions offset(long offset) {
        Assert.state(offset >= 0L && offset <= 0xFFFFFFFFL, "Offset mast be a value between 0 and 0xffffffff");
        return new Conditions(0L, offset);
    }

    public Conditions withOffset(long offset) {
        Assert.state(offset >= 0L && offset <= 0xFFFFFFFFL, "Offset mast be a value between 0 and 0xffffffff");
        this.offset = offset;
        return this;
    }

    public long getOffset() {
        return this.offset;
    }

    public static Conditions after(TarantoolTuple tuple) {
        return new Conditions(tuple);
    }

    public static <T> Conditions after(T tuple, ObjectConverter<T, ArrayValue> tupleConverter) {
        Assert.notNull(tupleConverter, "Tuple to ArrayValue converter should not be null");
        return new Conditions(new StartTupleWrapper<T>(tuple, tupleConverter));
    }

    public Conditions startAfter(TarantoolTuple tuple) {
        this.startTuple = tuple;
        return this;
    }

    public <T> Conditions startAfter(T tuple, ObjectConverter<T, ArrayValue> tupleConverter) {
        Assert.notNull(tupleConverter, "Tuple to ArrayValue converter should not be null");
        this.startTuple = new StartTupleWrapper<T>(tuple, tupleConverter);
        return this;
    }

    public Packable getStartTuple() {
        return this.startTuple;
    }

    public static Conditions indexEquals(String indexName, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.EQ, new NamedIndex(indexName), indexPartValues));
    }

    public Conditions andIndexEquals(String indexName, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.EQ, new NamedIndex(indexName), indexPartValues));
        return this;
    }

    public static Conditions indexEquals(int indexId, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.EQ, new IdIndex(indexId), indexPartValues));
    }

    public Conditions andIndexEquals(int indexId, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.EQ, new IdIndex(indexId), indexPartValues));
        return this;
    }

    public static Conditions indexGreaterThan(String indexName, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.GT, new NamedIndex(indexName), indexPartValues));
    }

    public Conditions andIndexGreaterThan(String indexName, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.GT, new NamedIndex(indexName), indexPartValues));
        return this;
    }

    public static Conditions indexGreaterThan(int indexId, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.GT, new IdIndex(indexId), indexPartValues));
    }

    public Conditions andIndexGreaterThan(int indexId, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.GT, new IdIndex(indexId), indexPartValues));
        return this;
    }

    public static Conditions indexGreaterOrEquals(String indexName, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.GE, new NamedIndex(indexName), indexPartValues));
    }

    public Conditions andIndexGreaterOrEquals(String indexName, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.GE, new NamedIndex(indexName), indexPartValues));
        return this;
    }

    public static Conditions indexGreaterOrEquals(int indexId, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.GE, new IdIndex(indexId), indexPartValues));
    }

    public Conditions andIndexGreaterOrEquals(int indexId, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.GE, new IdIndex(indexId), indexPartValues));
        return this;
    }

    public static Conditions indexLessThan(String indexName, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.LT, new NamedIndex(indexName), indexPartValues));
    }

    public Conditions andIndexLessThan(String indexName, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.LT, new NamedIndex(indexName), indexPartValues));
        return this;
    }

    public static Conditions indexLessThan(int indexId, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.LT, new IdIndex(indexId), indexPartValues));
    }

    public Conditions andIndexLessThan(int indexId, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.LT, new IdIndex(indexId), indexPartValues));
        return this;
    }

    public static Conditions indexLessOrEquals(String indexName, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.LE, new NamedIndex(indexName), indexPartValues));
    }

    public Conditions andIndexLessOrEquals(String indexName, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.LE, new NamedIndex(indexName), indexPartValues));
        return this;
    }

    public static Conditions indexLessOrEquals(int indexId, List<?> indexPartValues) {
        return new Conditions(new IndexValueCondition(Operator.LE, new IdIndex(indexId), indexPartValues));
    }

    public Conditions andIndexLessOrEquals(int indexId, List<?> indexPartValues) {
        this.conditions.add(new IndexValueCondition(Operator.LE, new IdIndex(indexId), indexPartValues));
        return this;
    }

    public static Conditions equals(String fieldName, Object value) {
        return new Conditions(new FieldValueCondition(Operator.EQ, new NamedField(fieldName), value));
    }

    public Conditions andEquals(String fieldName, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.EQ, new NamedField(fieldName), value));
        return this;
    }

    public static Conditions equals(int fieldPosition, Object value) {
        return new Conditions(new FieldValueCondition(Operator.EQ, new PositionField(fieldPosition), value));
    }

    public Conditions andEquals(int fieldPosition, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.EQ, new PositionField(fieldPosition), value));
        return this;
    }

    public static Conditions greaterThan(String fieldName, Object value) {
        return new Conditions(new FieldValueCondition(Operator.GT, new NamedField(fieldName), value));
    }

    public Conditions andGreaterThan(String fieldName, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.GT, new NamedField(fieldName), value));
        return this;
    }

    public static Conditions greaterThan(int fieldPosition, Object value) {
        return new Conditions(new FieldValueCondition(Operator.GT, new PositionField(fieldPosition), value));
    }

    public Conditions andGreaterThan(int fieldPosition, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.GT, new PositionField(fieldPosition), value));
        return this;
    }

    public static Conditions greaterOrEquals(String fieldName, Object value) {
        return new Conditions(new FieldValueCondition(Operator.GE, new NamedField(fieldName), value));
    }

    public Conditions andGreaterOrEquals(String fieldName, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.GE, new NamedField(fieldName), value));
        return this;
    }

    public static Conditions greaterOrEquals(int fieldPosition, Object value) {
        return new Conditions(new FieldValueCondition(Operator.GE, new PositionField(fieldPosition), value));
    }

    public Conditions andGreaterOrEquals(int fieldPosition, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.GE, new PositionField(fieldPosition), value));
        return this;
    }

    public static Conditions lessThan(String fieldName, Object value) {
        return new Conditions(new FieldValueCondition(Operator.LT, new NamedField(fieldName), value));
    }

    public Conditions andLessThan(String fieldName, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.LT, new NamedField(fieldName), value));
        return this;
    }

    public static Conditions lessThan(int fieldPosition, Object value) {
        return new Conditions(new FieldValueCondition(Operator.LT, new PositionField(fieldPosition), value));
    }

    public Conditions andLessThan(int fieldPosition, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.LT, new PositionField(fieldPosition), value));
        return this;
    }

    public static Conditions lessOrEquals(String fieldName, Object value) {
        return new Conditions(new FieldValueCondition(Operator.LE, new NamedField(fieldName), value));
    }

    public Conditions andLessOrEquals(String fieldName, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.LE, new NamedField(fieldName), value));
        return this;
    }

    public static Conditions lessOrEquals(int fieldPosition, Object value) {
        return new Conditions(new FieldValueCondition(Operator.LE, new PositionField(fieldPosition), value));
    }

    public Conditions andLessOrEquals(int fieldPosition, Object value) {
        this.conditions.add(new FieldValueCondition(Operator.LE, new PositionField(fieldPosition), value));
        return this;
    }

    public List<?> toProxyQuery(TarantoolMetadataOperations operations, TarantoolSpaceMetadata spaceMetadata) {
        if (this.offset > 0L) {
            throw new TarantoolClientException("Offset is not supported");
        }
        HashMap<String, List> indexConditions = new HashMap<String, List>();
        HashMap<Integer, List> fieldConditions = new HashMap<Integer, List>();
        HashMap<Integer, TarantoolFieldMetadata> selectedFields = new HashMap<Integer, TarantoolFieldMetadata>();
        for (Condition condition : this.conditions) {
            List current;
            if (condition instanceof IndexValueCondition) {
                TarantoolIndexMetadata indexMetadata = (TarantoolIndexMetadata)condition.field().metadata(operations, spaceMetadata);
                current = indexConditions.computeIfAbsent(indexMetadata.getIndexName(), name -> new LinkedList());
                current.add(this.convertIndexIfNecessary((IndexValueCondition)condition, indexMetadata.getIndexName()));
                continue;
            }
            TarantoolFieldMetadata fieldMetadata = (TarantoolFieldMetadata)condition.field().metadata(operations, spaceMetadata);
            current = fieldConditions.computeIfAbsent(fieldMetadata.getFieldPosition(), f -> new LinkedList());
            current.add((FieldValueCondition)condition);
            selectedFields.putIfAbsent(fieldMetadata.getFieldPosition(), fieldMetadata);
        }
        if (indexConditions.size() > 1) {
            throw new TarantoolClientException("Filtering by more than one index is not supported");
        }
        ArrayList allConditions = new ArrayList();
        if (indexConditions.size() > 0) {
            allConditions.addAll(this.conditionsListToLists((List)indexConditions.values().iterator().next(), operations, spaceMetadata));
            for (List conditionList : fieldConditions.values()) {
                allConditions.addAll(this.conditionsListToLists(conditionList, operations, spaceMetadata));
            }
        } else {
            Optional<TarantoolIndexMetadata> optional = Conditions.findCoveringIndex(operations, spaceMetadata, selectedFields.values());
            if (optional.isPresent()) {
                for (TarantoolIndexPartMetadata part : optional.get().getIndexParts()) {
                    List conditions = (List)fieldConditions.get(part.getFieldIndex());
                    if (conditions == null) continue;
                    allConditions.addAll(this.conditionsListToLists(conditions, operations, spaceMetadata));
                    fieldConditions.remove(part.getFieldIndex());
                }
            }
            for (List conditionList : fieldConditions.values()) {
                allConditions.addAll(this.conditionsListToLists(conditionList, operations, spaceMetadata));
            }
        }
        return allConditions;
    }

    private IndexValueCondition convertIndexIfNecessary(IndexValueCondition condition, String indexName) {
        if (!(condition.field() instanceof IdIndex)) {
            return condition;
        }
        return new IndexValueCondition(condition.operator(), new NamedIndex(indexName), (List<?>)condition.value());
    }

    private List<List<?>> conditionsListToLists(List<? extends Condition> conditionsList, TarantoolMetadataOperations operations, TarantoolSpaceMetadata spaceMetadata) {
        return conditionsList.stream().map(c -> c.toList(operations, spaceMetadata)).collect(Collectors.toList());
    }

    public TarantoolIndexQuery toIndexQuery(TarantoolMetadataOperations operations, TarantoolSpaceMetadata spaceMetadata) {
        TarantoolIndexQuery query;
        if (this.startTuple != null) {
            throw new TarantoolClientException("'startAfter' is not supported");
        }
        HashMap<String, List<IndexValueCondition>> indexConditions = new HashMap<String, List<IndexValueCondition>>();
        HashMap<String, TarantoolIndexMetadata> selectedIndexes = new HashMap<String, TarantoolIndexMetadata>();
        HashMap<String, List<FieldValueCondition>> fieldConditions = new HashMap<String, List<FieldValueCondition>>();
        HashMap<String, TarantoolFieldMetadata> selectedFields = new HashMap<String, TarantoolFieldMetadata>();
        for (Condition condition : this.conditions) {
            List current;
            if (condition instanceof IndexValueCondition) {
                TarantoolIndexMetadata indexMetadata = (TarantoolIndexMetadata)condition.field().metadata(operations, spaceMetadata);
                current = indexConditions.computeIfAbsent(indexMetadata.getIndexName(), name -> new LinkedList());
                if (current.size() > 0) {
                    throw new TarantoolClientException("Multiple conditions for one index are not supported");
                }
                current.add((IndexValueCondition)condition);
                selectedIndexes.putIfAbsent(indexMetadata.getIndexName(), indexMetadata);
                continue;
            }
            TarantoolFieldMetadata fieldMetadata = (TarantoolFieldMetadata)condition.field().metadata(operations, spaceMetadata);
            current = fieldConditions.computeIfAbsent(fieldMetadata.getFieldName(), f -> new LinkedList());
            if (current.size() > 0) {
                throw new TarantoolClientException("Multiple conditions for one field are not supported");
            }
            current.add((FieldValueCondition)condition);
            selectedFields.putIfAbsent(fieldMetadata.getFieldName(), fieldMetadata);
        }
        if (indexConditions.size() > 1) {
            throw new TarantoolClientException("Filtering by more than one index is not supported");
        }
        if (indexConditions.size() > 0) {
            if (fieldConditions.size() > 0) {
                throw new TarantoolClientException("Filtering simultaneously by index and fields is not supported");
            }
            query = this.indexQueryFromIndexValues(indexConditions, selectedIndexes);
        } else if (selectedFields.size() > 0) {
            TarantoolIndexMetadata suitableIndex = Conditions.findSuitableIndex(operations, spaceMetadata, selectedFields.values());
            query = this.indexQueryFromFieldValues(suitableIndex, fieldConditions, selectedFields);
        } else {
            query = new TarantoolIndexQuery(0).withIteratorType(this.descending ? TarantoolIteratorType.ITER_REQ : TarantoolIteratorType.ITER_EQ);
        }
        return query;
    }

    private TarantoolIndexQuery indexQueryFromIndexValues(Map<String, List<IndexValueCondition>> indexConditions, Map<String, TarantoolIndexMetadata> selectedIndexes) {
        IndexValueCondition condition = indexConditions.values().iterator().next().get(0);
        TarantoolIndexMetadata indexMetadata = selectedIndexes.values().iterator().next();
        TarantoolIteratorType iteratorType = condition.operator().toIteratorType();
        return new TarantoolIndexQuery(indexMetadata.getIndexId()).withIteratorType(this.descending ? iteratorType.reverse() : iteratorType).withKeyValues((List<?>)condition.value());
    }

    private TarantoolIndexQuery indexQueryFromFieldValues(TarantoolIndexMetadata suitableIndex, Map<String, List<FieldValueCondition>> fieldConditions, Map<String, TarantoolFieldMetadata> selectedFields) {
        Operator selectedOperator = null;
        List<Object> fieldValues = Arrays.asList(new Object[suitableIndex.getIndexParts().size()]);
        for (Map.Entry<String, List<FieldValueCondition>> conditions : fieldConditions.entrySet()) {
            FieldValueCondition condition = conditions.getValue().iterator().next();
            if (selectedOperator == null) {
                selectedOperator = condition.operator();
            } else if (!condition.operator().equals((Object)selectedOperator)) {
                throw new TarantoolClientException("Different conditions for index parts are not supported");
            }
            TarantoolFieldMetadata field = selectedFields.get(conditions.getKey());
            int partPosition = suitableIndex.getIndexPartPositionByFieldPosition(field.getFieldPosition()).orElseThrow(() -> new TarantoolClientException("Field %s not found in index %s", field.getFieldName(), suitableIndex.getIndexName()));
            fieldValues.set(partPosition, condition.value());
        }
        TarantoolIteratorType iteratorType = selectedOperator != null ? selectedOperator.toIteratorType() : TarantoolIteratorType.ITER_EQ;
        return new TarantoolIndexQuery(suitableIndex.getIndexId()).withIteratorType(this.descending ? iteratorType.reverse() : iteratorType).withKeyValues(fieldValues);
    }

    private static Optional<TarantoolIndexMetadata> findCoveringIndex(TarantoolMetadataOperations operations, TarantoolSpaceMetadata spaceMetadata, Collection<TarantoolFieldMetadata> selectedFields) {
        Map<String, TarantoolIndexMetadata> allIndexes = operations.getSpaceIndexes(spaceMetadata.getSpaceName()).orElseThrow(() -> new TarantoolClientException("Metadata for space %s not found", spaceMetadata.getSpaceName()));
        Optional<TarantoolIndexMetadata> coveringIndex = allIndexes.values().stream().map(metadata -> new AbstractMap.SimpleEntry<Long, TarantoolIndexMetadata>(Conditions.calculateCoverage(metadata, selectedFields), (TarantoolIndexMetadata)metadata)).filter(entry -> (Long)entry.getKey() > 0L).max(Comparator.comparingLong(AbstractMap.SimpleEntry::getKey)).map(AbstractMap.SimpleEntry::getValue);
        return coveringIndex;
    }

    private static long calculateCoverage(TarantoolIndexMetadata metadata, Collection<TarantoolFieldMetadata> selectedFields) {
        AtomicBoolean firstFieldIsSet = new AtomicBoolean(false);
        long count = selectedFields.stream().map(f -> metadata.getIndexPartPositionByFieldPosition(f.getFieldPosition())).filter(Optional::isPresent).map(Optional::get).peek(indexPosition -> {
            if (indexPosition == 0) {
                firstFieldIsSet.set(true);
            }
        }).count();
        return firstFieldIsSet.get() ? count : 0L;
    }

    private static TarantoolIndexMetadata findSuitableIndex(TarantoolMetadataOperations operations, TarantoolSpaceMetadata spaceMetadata, Collection<TarantoolFieldMetadata> selectedFields) {
        Map<String, TarantoolIndexMetadata> allIndexes = operations.getSpaceIndexes(spaceMetadata.getSpaceName()).orElseThrow(() -> new TarantoolClientException("Metadata for space %s not found", spaceMetadata.getSpaceName()));
        TarantoolIndexMetadata suitableIndex = allIndexes.values().stream().filter(metadata -> Conditions.isSuitableIndex(metadata, selectedFields)).min(Comparator.comparingInt(m -> m.getIndexParts().size())).orElseThrow(() -> new TarantoolClientException("No indexes that fit the passed fields are found"));
        return suitableIndex;
    }

    private static boolean isSuitableIndex(TarantoolIndexMetadata indexMetadata, Collection<TarantoolFieldMetadata> selectedFields) {
        Map<Integer, TarantoolIndexPartMetadata> indexParts = indexMetadata.getIndexPartsByPosition();
        if (indexParts.size() < selectedFields.size()) {
            return false;
        }
        for (TarantoolFieldMetadata fieldMetadata : selectedFields) {
            if (indexParts.containsKey(fieldMetadata.getFieldPosition())) continue;
            return false;
        }
        return true;
    }

    private static class StartTupleWrapper<T>
    implements Packable {
        private final T tuple;
        private final ObjectConverter<T, ArrayValue> tupleConverter;

        StartTupleWrapper(T tuple, ObjectConverter<T, ArrayValue> tupleConverter) {
            this.tuple = tuple;
            this.tupleConverter = tupleConverter;
        }

        @Override
        public Value toMessagePackValue(MessagePackObjectMapper mapper) {
            return this.tupleConverter.toValue(this.tuple);
        }
    }
}

