/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.conditions;

import io.tarantool.driver.api.conditions.FieldIdentifier;
import io.tarantool.driver.exceptions.TarantoolIndexNotFoundException;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.utils.Assert;
import java.util.Optional;

public class IdIndex
implements FieldIdentifier<TarantoolIndexMetadata, Integer> {
    private int position;

    public IdIndex(int position) {
        Assert.state(position >= 0, "Index position should be greater or equal 0");
        this.position = position;
    }

    @Override
    public TarantoolIndexMetadata metadata(TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        Optional<TarantoolIndexMetadata> indexMetadata = metadataOperations.getIndexById(spaceMetadata.getSpaceName(), this.position);
        if (!indexMetadata.isPresent()) {
            throw new TarantoolIndexNotFoundException(spaceMetadata.getSpaceName(), this.position);
        }
        return indexMetadata.get();
    }

    @Override
    public Integer toIdentifier() {
        return this.position;
    }
}

