/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.space;

import io.tarantool.driver.ProxyTarantoolClient;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.AbstractTarantoolResultMapper;
import io.tarantool.driver.mappers.TarantoolCallResultMapper;
import io.tarantool.driver.mappers.TarantoolCallResultMapperFactory;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import io.tarantool.driver.proxy.DeleteProxyOperation;
import io.tarantool.driver.proxy.InsertProxyOperation;
import io.tarantool.driver.proxy.ProxyOperation;
import io.tarantool.driver.proxy.ReplaceProxyOperation;
import io.tarantool.driver.proxy.SelectProxyOperation;
import io.tarantool.driver.proxy.UpdateProxyOperation;
import io.tarantool.driver.proxy.UpsertProxyOperation;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.ArrayValue;

public class ProxyTarantoolSpace
implements TarantoolSpaceOperations {
    private final String spaceName;
    private final ProxyTarantoolClient client;
    private final TarantoolMetadataOperations metadataOperations;
    private final TarantoolSpaceMetadata spaceMetadata;
    private final TarantoolCallResultMapperFactory tarantoolResultMapperFactory;

    public ProxyTarantoolSpace(ProxyTarantoolClient client, TarantoolSpaceMetadata spaceMetadata) {
        this.client = client;
        this.spaceMetadata = spaceMetadata;
        this.spaceName = spaceMetadata.getSpaceName();
        this.metadataOperations = client.metadata();
        this.tarantoolResultMapperFactory = new TarantoolCallResultMapperFactory(client.getConfig().getMessagePackMapper());
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> delete(Conditions conditions) throws TarantoolClientException {
        return this.delete(conditions, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> delete(Conditions conditions, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.delete(conditions, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> delete(Conditions conditions, TarantoolCallResultMapper<T> resultMapper) throws TarantoolClientException {
        TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
        DeleteProxyOperation operation = new DeleteProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getDeleteFunctionName()).withIndexQuery(indexQuery).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> insert(TarantoolTuple tuple) throws TarantoolClientException {
        return this.insert(tuple, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> insert(TarantoolTuple tuple, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.insert(tuple, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> insert(TarantoolTuple tuple, TarantoolCallResultMapper<T> resultMapper) throws TarantoolClientException {
        InsertProxyOperation operation = new InsertProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getInsertFunctionName()).withTuple(tuple).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> replace(TarantoolTuple tuple) throws TarantoolClientException {
        return this.replace(tuple, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> replace(TarantoolTuple tuple, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.replace(tuple, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> replace(TarantoolTuple tuple, TarantoolCallResultMapper<T> resultMapper) throws TarantoolClientException {
        ReplaceProxyOperation operation = new ReplaceProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getReplaceFunctionName()).withTuple(tuple).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(Conditions conditions) throws TarantoolClientException {
        return this.select(conditions, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> select(Conditions conditions, Class<T> tupleClass) throws TarantoolClientException {
        AbstractTarantoolResultMapper mapper;
        if (TarantoolTuple.class.isAssignableFrom(tupleClass)) {
            mapper = this.defaultTupleResultMapper();
        } else {
            ValueConverter<ArrayValue, T> converter = this.getConverter(tupleClass);
            mapper = this.tarantoolResultMapperFactory.withConverter((Class)tupleClass, (ValueConverter)converter);
        }
        return this.select(conditions, (TarantoolCallResultMapper<T>)mapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> select(Conditions conditions, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.select(conditions, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> select(Conditions conditions, TarantoolCallResultMapper<T> resultMapper) throws TarantoolClientException {
        SelectProxyOperation operation = new SelectProxyOperation.Builder(this.metadataOperations, this.spaceMetadata).withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getSelectFunctionName()).withConditions(conditions).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> update(Conditions conditions, TarantoolTuple tuple) {
        return this.update(conditions, TupleOperations.fromTarantoolTuple(tuple), this.defaultTupleResultMapper());
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> update(Conditions conditions, TupleOperations operations) {
        return this.update(conditions, operations, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> update(Conditions conditions, TupleOperations operations, ValueConverter<ArrayValue, T> tupleMapper) {
        return this.update(conditions, operations, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> update(Conditions conditions, TupleOperations operations, TarantoolCallResultMapper<T> resultMapper) {
        TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
        UpdateProxyOperation operation = new UpdateProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getUpdateFunctionName()).withIndexQuery(indexQuery).withTupleOperation(operations).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> upsert(Conditions conditions, TarantoolTuple tuple, TupleOperations operations) {
        return this.upsert(conditions, tuple, operations, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> upsert(Conditions conditions, TarantoolTuple tuple, TupleOperations operations, ValueConverter<ArrayValue, T> tupleMapper) {
        return this.upsert(conditions, tuple, operations, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> upsert(Conditions conditions, TarantoolTuple tuple, TupleOperations operations, TarantoolCallResultMapper<T> resultMapper) {
        UpsertProxyOperation operation = new UpsertProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getUpsertFunctionName()).withTuple(tuple).withTupleOperation(operations).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    private TarantoolCallResultMapper<TarantoolTuple> defaultTupleResultMapper() {
        return this.tarantoolResultMapperFactory.withDefaultTupleValueConverter(this.spaceMetadata);
    }

    private <T> ValueConverter<ArrayValue, T> getConverter(Class<T> tupleClass) {
        Optional<ValueConverter<ArrayValue, T>> converter = this.client.getConfig().getMessagePackMapper().getValueConverter(ArrayValue.class, tupleClass);
        if (!converter.isPresent()) {
            throw new TarantoolClientException("No ArrayValue converter for type " + tupleClass + " is present");
        }
        return converter.get();
    }

    private <T> CompletableFuture<TarantoolResult<T>> executeOperation(ProxyOperation<T> operation) {
        return operation.execute();
    }

    @Override
    public TarantoolSpaceMetadata getMetadata() {
        return this.spaceMetadata;
    }

    public String toString() {
        return String.format("ProxyTarantoolSpace [%s]", this.spaceName);
    }
}

