/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.space;

import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolSpaceOperationException;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.TarantoolSimpleResultMapperFactory;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.requests.TarantoolDeleteRequest;
import io.tarantool.driver.protocol.requests.TarantoolInsertRequest;
import io.tarantool.driver.protocol.requests.TarantoolReplaceRequest;
import io.tarantool.driver.protocol.requests.TarantoolSelectRequest;
import io.tarantool.driver.protocol.requests.TarantoolUpdateRequest;
import io.tarantool.driver.protocol.requests.TarantoolUpsertRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.ArrayValue;

public class TarantoolSpace
implements TarantoolSpaceOperations {
    private final int spaceId;
    private final TarantoolClientConfig config;
    private final TarantoolConnectionManager connectionManager;
    private final TarantoolSpaceMetadata spaceMetadata;
    private final TarantoolMetadataOperations metadataOperations;
    private final TarantoolSimpleResultMapperFactory tarantoolResultMapperFactory;

    public TarantoolSpace(TarantoolClientConfig config, TarantoolConnectionManager connectionManager, TarantoolSpaceMetadata spaceMetadata, TarantoolMetadataOperations metadataOperations) {
        this.spaceId = spaceMetadata.getSpaceId();
        this.config = config;
        this.connectionManager = connectionManager;
        this.spaceMetadata = spaceMetadata;
        this.metadataOperations = metadataOperations;
        this.tarantoolResultMapperFactory = new TarantoolSimpleResultMapperFactory(config.getMessagePackMapper());
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> delete(Conditions conditions) throws TarantoolClientException {
        return this.delete(conditions, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> delete(Conditions conditions, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.delete(conditions, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> delete(Conditions conditions, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
            TarantoolDeleteRequest request = new TarantoolDeleteRequest.Builder().withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withKeyValues(indexQuery.getKeyValues()).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> insert(TarantoolTuple tuple) throws TarantoolClientException {
        return this.insert(tuple, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> insert(TarantoolTuple tuple, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.replace(tuple, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> insert(TarantoolTuple tuple, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolInsertRequest request = new TarantoolInsertRequest.Builder().withSpaceId(this.spaceId).withTuple(tuple).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> replace(TarantoolTuple tuple) throws TarantoolClientException {
        return this.replace(tuple, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> replace(TarantoolTuple tuple, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.replace(tuple, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> replace(TarantoolTuple tuple, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolReplaceRequest request = new TarantoolReplaceRequest.Builder().withSpaceId(this.spaceId).withTuple(tuple).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(Conditions conditions) throws TarantoolClientException {
        return this.select(conditions, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> select(Conditions conditions, Class<T> tupleClass) throws TarantoolClientException {
        MessagePackValueMapper mapper;
        if (TarantoolTuple.class.isAssignableFrom(tupleClass)) {
            mapper = this.defaultTupleResultMapper();
        } else {
            ValueConverter<ArrayValue, T> converter = this.getConverter(tupleClass);
            mapper = this.tarantoolResultMapperFactory.withConverter((Class)tupleClass, (ValueConverter)converter);
        }
        return this.select(conditions, mapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> select(Conditions conditions, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.select(conditions, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> select(Conditions conditions, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
            TarantoolSelectRequest request = new TarantoolSelectRequest.Builder().withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withIteratorType(indexQuery.getIteratorType()).withKeyValues(indexQuery.getKeyValues()).withLimit(conditions.getLimit()).withOffset(conditions.getOffset()).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> update(Conditions conditions, TarantoolTuple tuple) {
        return this.update(conditions, TupleOperations.fromTarantoolTuple(tuple), this.defaultTupleResultMapper());
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> update(Conditions conditions, TupleOperations operations) {
        return this.update(conditions, operations, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> update(Conditions conditions, TupleOperations operations, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.update(conditions, operations, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> update(Conditions conditions, TupleOperations operations, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
            Optional<TarantoolIndexMetadata> indexMetadata = this.metadataOperations.getIndexById(this.spaceId, indexQuery.getIndexId());
            if (!indexMetadata.isPresent() || !indexMetadata.get().isUnique()) {
                throw new TarantoolSpaceOperationException("Index must be primary or unique for update operation");
            }
            TarantoolUpdateRequest request = new TarantoolUpdateRequest.Builder(this.spaceMetadata).withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withKeyValues(indexQuery.getKeyValues()).withTupleOperations(operations).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> upsert(Conditions conditions, TarantoolTuple tuple, TupleOperations operations) {
        return this.upsert(conditions, tuple, operations, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> upsert(Conditions conditions, TarantoolTuple tuple, TupleOperations operations, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.upsert(conditions, tuple, operations, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> upsert(Conditions conditions, TarantoolTuple tuple, TupleOperations operations, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
            TarantoolUpsertRequest request = new TarantoolUpsertRequest.Builder(this.spaceMetadata).withSpaceId(this.spaceId).withKeyValues(indexQuery.getKeyValues()).withTuple(tuple).withTupleOperations(operations).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    private <T> ValueConverter<ArrayValue, T> getConverter(Class<T> tupleClass) {
        Optional<ValueConverter<ArrayValue, T>> converter = this.config.getMessagePackMapper().getValueConverter(ArrayValue.class, tupleClass);
        if (!converter.isPresent()) {
            throw new TarantoolClientException("No ArrayValue converter for type " + tupleClass + " is present");
        }
        return converter.get();
    }

    private MessagePackValueMapper defaultTupleResultMapper() {
        return this.tarantoolResultMapperFactory.withDefaultTupleValueConverter(this.spaceMetadata);
    }

    private <T> CompletableFuture<TarantoolResult<T>> sendRequest(TarantoolRequest request, MessagePackValueMapper resultMapper) {
        try {
            return this.connectionManager.getConnection().sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public TarantoolSpaceMetadata getMetadata() {
        return this.spaceMetadata;
    }

    public String toString() {
        return String.format("TarantoolSpace %s [%d]", this.spaceMetadata.getSpaceName(), this.spaceMetadata.getSpaceId());
    }
}

