/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.cluster;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.tarantool.driver.StandaloneTarantoolClient;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.cluster.AbstractDiscoveryClusterAddressProvider;
import io.tarantool.driver.cluster.BinaryClusterDiscoveryEndpoint;
import io.tarantool.driver.cluster.ServerNodeInfo;
import io.tarantool.driver.cluster.TarantoolClusterDiscoveryConfig;
import io.tarantool.driver.exceptions.TarantoolClientException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BinaryDiscoveryClusterAddressProvider
extends AbstractDiscoveryClusterAddressProvider {
    private final BinaryClusterDiscoveryEndpoint endpoint;
    private final TarantoolClient client;
    private final ObjectMapper objectMapper;

    public BinaryDiscoveryClusterAddressProvider(TarantoolClusterDiscoveryConfig discoveryConfig) {
        super(discoveryConfig);
        this.endpoint = (BinaryClusterDiscoveryEndpoint)discoveryConfig.getEndpoint();
        TarantoolClientConfig config = TarantoolClientConfig.builder().withCredentials(this.endpoint.getCredentials()).withConnectTimeout(discoveryConfig.getConnectTimeout()).withReadTimeout(discoveryConfig.getReadTimeout()).build();
        this.client = new StandaloneTarantoolClient(config, this.endpoint.getServerAddress());
        this.objectMapper = new ObjectMapper();
        this.startDiscoveryTask();
    }

    @Override
    protected Collection<TarantoolServerAddress> discoverAddresses() {
        try {
            Map responseMap;
            List<?> functionResult = this.client.call(this.endpoint.getDiscoveryFunction(), Collections.emptyList()).get();
            String valueAsString = this.objectMapper.writeValueAsString(functionResult.get(0));
            TypeReference<HashMap<String, ServerNodeInfo>> typeReference = new TypeReference<HashMap<String, ServerNodeInfo>>(){};
            try {
                responseMap = (Map)this.objectMapper.readValue(valueAsString, (TypeReference)typeReference);
            }
            catch (Exception ignored) {
                throw new TarantoolClientException("Invalid result format (%s)", valueAsString);
            }
            return responseMap.values().stream().filter(ServerNodeInfo::isAvailable).map(v -> new TarantoolServerAddress(v.getUri())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new TarantoolClientException("Cluster discovery task error", e);
        }
    }
}

