/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.ConnectionSelectionStrategy;
import io.tarantool.driver.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.core.CyclingIterator;
import io.tarantool.driver.core.TarantoolConnection;
import io.tarantool.driver.core.TarantoolConnectionIterator;
import io.tarantool.driver.exceptions.NoAvailableConnectionsException;
import io.tarantool.driver.utils.Assert;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class TarantoolConnectionSelectionStrategies {

    static final class ParallelRoundRobinStrategy
    implements ConnectionSelectionStrategy {
        private final TarantoolClientConfig config;
        private final CyclingIterator<TarantoolConnectionIterator> iteratorsIterator;
        private final int maxAttempts;

        ParallelRoundRobinStrategy(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            this.config = config;
            this.iteratorsIterator = new CyclingIterator<TarantoolConnectionIterator>(this.populateIterators(connections));
            this.maxAttempts = connections.size();
        }

        private Collection<TarantoolConnectionIterator> populateIterators(Collection<TarantoolConnection> connections) {
            int groupSize = this.config.getConnections();
            AtomicInteger currentSize = new AtomicInteger(0);
            return connections.stream().collect(Collectors.groupingBy(conn -> currentSize.getAndIncrement() / groupSize)).values().stream().map(TarantoolConnectionIterator::new).filter(CyclingIterator::hasNext).collect(Collectors.toList());
        }

        @Override
        public TarantoolConnection next() throws NoAvailableConnectionsException {
            if (this.iteratorsIterator.hasNext()) {
                int attempts = 0;
                while (attempts++ < this.maxAttempts) {
                    TarantoolConnection connection = (TarantoolConnection)this.iteratorsIterator.next().next();
                    if (!connection.isConnected()) continue;
                    return connection;
                }
            }
            throw new NoAvailableConnectionsException();
        }
    }

    public static enum ParallelRoundRobinStrategyFactory implements ConnectionSelectionStrategyFactory
    {
        INSTANCE;


        @Override
        public ConnectionSelectionStrategy create(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            Assert.notNull(connections, "The collection of Tarantool connections should not be null");
            return new ParallelRoundRobinStrategy(config, connections);
        }
    }

    static final class RoundRobinStrategy
    implements ConnectionSelectionStrategy {
        private final TarantoolConnectionIterator connectionIterator;
        private final int maxAttempts;

        RoundRobinStrategy(Collection<TarantoolConnection> connections) {
            this.connectionIterator = new TarantoolConnectionIterator(connections);
            this.maxAttempts = connections.size();
        }

        @Override
        public TarantoolConnection next() throws NoAvailableConnectionsException {
            if (this.connectionIterator.hasNext()) {
                int attempts = 0;
                while (attempts++ < this.maxAttempts) {
                    TarantoolConnection connection = (TarantoolConnection)this.connectionIterator.next();
                    if (!connection.isConnected()) continue;
                    return connection;
                }
            }
            throw new NoAvailableConnectionsException();
        }
    }

    public static enum RoundRobinStrategyFactory implements ConnectionSelectionStrategyFactory
    {
        INSTANCE;


        @Override
        public ConnectionSelectionStrategy create(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            Assert.notNull(connections, "The collection of Tarantool connections should not be null");
            return new RoundRobinStrategy(connections);
        }
    }
}

