/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.api.TarantoolResultImpl;
import io.tarantool.driver.exceptions.TarantoolFunctionCallException;
import io.tarantool.driver.mappers.AbstractTarantoolResultMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.ValueConverter;
import java.util.Map;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableArrayValueImpl;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public class TarantoolCallResultMapper<T>
extends AbstractTarantoolResultMapper<T> {
    private static final ImmutableStringValue RESULT_META = new ImmutableStringValueImpl("metadata");
    private static final ImmutableStringValue RESULT_ROWS = new ImmutableStringValueImpl("rows");

    public TarantoolCallResultMapper(MessagePackValueMapper valueMapper, ValueConverter<ArrayValue, T> tupleConverter) {
        super(valueMapper, (ArrayValue v) -> {
            ArrayValue tuples = v;
            if (v.size() == 2 && v.get(0).isNilValue() && !v.get(1).isNilValue()) {
                if (v.get(1).isMapValue()) {
                    throw new TarantoolFunctionCallException(v.get(1).asMapValue());
                }
                throw new TarantoolFunctionCallException(v.get(1).toString());
            }
            if (v.size() == 1) {
                if (v.get(0).isNilValue()) {
                    tuples = ImmutableArrayValueImpl.empty();
                } else if (v.get(0).isMapValue() && TarantoolCallResultMapper.hasRowsAndMetadata(v.get(0).asMapValue().map())) {
                    tuples = ((Value)v.get(0).asMapValue().map().get(RESULT_ROWS)).asArrayValue();
                } else if (v.get(0).isArrayValue()) {
                    tuples = v.get(0).asArrayValue();
                }
            }
            return new TarantoolResultImpl(tuples, tupleConverter);
        });
    }

    private static boolean hasRowsAndMetadata(Map<Value, Value> valueMap) {
        return valueMap.containsKey(RESULT_META) && valueMap.containsKey(RESULT_ROWS);
    }
}

