/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.utils.Assert;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

public abstract class AbstractTarantoolMetadata
implements TarantoolMetadataOperations {
    protected final Map<String, TarantoolSpaceMetadata> spaceMetadata = new ConcurrentHashMap<String, TarantoolSpaceMetadata>();
    protected final Map<Integer, TarantoolSpaceMetadata> spaceMetadataById = new ConcurrentHashMap<Integer, TarantoolSpaceMetadata>();
    protected final Map<String, Map<String, TarantoolIndexMetadata>> indexMetadata = new ConcurrentHashMap<String, Map<String, TarantoolIndexMetadata>>();
    protected final Map<Integer, Map<String, TarantoolIndexMetadata>> indexMetadataBySpaceId = new ConcurrentHashMap<Integer, Map<String, TarantoolIndexMetadata>>();
    private final CountDownLatch initLatch = new CountDownLatch(1);

    protected Map<String, TarantoolSpaceMetadata> getSpaceMetadata() {
        this.awaitInitLatch();
        return this.spaceMetadata;
    }

    protected Map<Integer, TarantoolSpaceMetadata> getSpaceMetadataById() {
        this.awaitInitLatch();
        return this.spaceMetadataById;
    }

    protected Map<String, Map<String, TarantoolIndexMetadata>> getIndexMetadata() {
        this.awaitInitLatch();
        return this.indexMetadata;
    }

    protected Map<Integer, Map<String, TarantoolIndexMetadata>> getIndexMetadataBySpaceId() {
        this.awaitInitLatch();
        return this.indexMetadataBySpaceId;
    }

    @Override
    public CompletableFuture<Void> refresh() throws TarantoolClientException {
        return this.populateMetadata().whenComplete((v, ex) -> {
            if (this.initLatch.getCount() > 0L) {
                this.initLatch.countDown();
            }
            if (ex != null) {
                throw new TarantoolClientException("Failed to refresh spaces and indexes metadata", (Throwable)ex);
            }
        });
    }

    protected abstract CompletableFuture<Void> populateMetadata();

    @Override
    public Optional<TarantoolSpaceMetadata> getSpaceByName(String spaceName) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        return Optional.ofNullable(this.getSpaceMetadata().get(spaceName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexByName(int spaceId, String indexName) {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        Assert.hasText(indexName, "Index name must not be null or empty");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadataBySpaceId().get(spaceId);
        if (metaMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaMap.get(indexName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexByName(String spaceName, String indexName) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        Assert.hasText(indexName, "Index name must not be null or empty");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceName);
        if (metaMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaMap.get(indexName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexById(String spaceName, int indexId) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        Assert.state(indexId >= 0, "Index ID must be greater than or equal 0");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceName);
        if (metaMap == null) {
            return Optional.empty();
        }
        return metaMap.values().stream().filter(i -> i.getIndexId() == indexId).findFirst();
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexById(int spaceId, int indexId) {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        Assert.state(indexId >= 0, "Index ID must be greater than or equal 0");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadataBySpaceId().get(spaceId);
        if (metaMap == null) {
            return Optional.empty();
        }
        return metaMap.values().stream().filter(i -> i.getIndexId() == indexId).findFirst();
    }

    @Override
    public Optional<TarantoolSpaceMetadata> getSpaceById(int spaceId) {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        return Optional.ofNullable(this.getSpaceMetadataById().get(spaceId));
    }

    @Override
    public Optional<Map<String, TarantoolIndexMetadata>> getSpaceIndexes(int spaceId) {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        return Optional.ofNullable(this.getIndexMetadataBySpaceId().get(spaceId));
    }

    @Override
    public Optional<Map<String, TarantoolIndexMetadata>> getSpaceIndexes(String spaceName) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        return Optional.ofNullable(this.getIndexMetadata().get(spaceName));
    }

    private void awaitInitLatch() {
        if (this.initLatch.getCount() > 0L) {
            this.refresh();
        }
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException(e);
        }
    }
}

