/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.metadata.AbstractTarantoolMetadata;
import io.tarantool.driver.metadata.ProxyTarantoolSpaceMetadataContainer;
import io.tarantool.driver.metadata.ProxyTarantoolSpaceMetadataConverter;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ProxyTarantoolMetadata
extends AbstractTarantoolMetadata {
    private final String getMetadataFunctionName;
    private final TarantoolClient client;
    private final ProxyTarantoolSpaceMetadataConverter metadataConverter;

    public ProxyTarantoolMetadata(String getMetadataFunctionName, TarantoolClient client) {
        this.getMetadataFunctionName = getMetadataFunctionName;
        this.client = client;
        this.metadataConverter = new ProxyTarantoolSpaceMetadataConverter(client.getConfig().getMessagePackMapper());
    }

    @Override
    public CompletableFuture<Void> populateMetadata() throws TarantoolClientException {
        CompletableFuture<TarantoolResult<ProxyTarantoolSpaceMetadataContainer>> callResult = this.client.call(this.getMetadataFunctionName, this.metadataConverter);
        return callResult.thenAccept(result -> {
            this.spaceMetadata.clear();
            this.spaceMetadataById.clear();
            this.indexMetadata.clear();
            this.indexMetadataBySpaceId.clear();
            result.forEach(container -> {
                this.spaceMetadata.putAll(container.getSpaceMetadata());
                this.indexMetadata.putAll(container.getIndexMetadata());
                container.getSpaceMetadata().forEach((spaceName, spaceMetadata) -> {
                    this.spaceMetadataById.put(spaceMetadata.getSpaceId(), spaceMetadata);
                    Map indexesForSpace = (Map)this.indexMetadata.get(spaceMetadata.getSpaceName());
                    if (indexesForSpace != null) {
                        this.indexMetadataBySpaceId.put(spaceMetadata.getSpaceId(), indexesForSpace);
                    }
                });
            });
        });
    }
}

