/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolIndexOptions;
import io.tarantool.driver.metadata.TarantoolIndexPartMetadata;
import io.tarantool.driver.metadata.TarantoolIndexType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public class TarantoolIndexMetadataConverter
implements ValueConverter<ArrayValue, TarantoolIndexMetadata> {
    private static final ImmutableStringValue INDEX_FIELD_KEY = new ImmutableStringValueImpl("field");
    private static final ImmutableStringValue INDEX_TYPE_KEY = new ImmutableStringValueImpl("type");
    private final MessagePackValueMapper mapper;

    public TarantoolIndexMetadataConverter(MessagePackValueMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public TarantoolIndexMetadata fromValue(ArrayValue value) {
        Iterator it = value.iterator();
        TarantoolIndexMetadata metadata = new TarantoolIndexMetadata();
        metadata.setSpaceId((Integer)this.mapper.fromValue(((Value)it.next()).asIntegerValue()));
        metadata.setIndexId((Integer)this.mapper.fromValue(((Value)it.next()).asIntegerValue()));
        metadata.setIndexName((String)this.mapper.fromValue(((Value)it.next()).asStringValue()));
        metadata.setIndexType(TarantoolIndexType.fromString((String)this.mapper.fromValue(((Value)it.next()).asStringValue())));
        TarantoolIndexOptions indexOptions = new TarantoolIndexOptions();
        Map optionsMap = (Map)this.mapper.fromValue(((Value)it.next()).asMapValue());
        indexOptions.setUnique((Boolean)optionsMap.get("unique"));
        metadata.setIndexOptions(indexOptions);
        ArrayValue indexPartsValue = ((Value)it.next()).asArrayValue();
        List<TarantoolIndexPartMetadata> indexParts = new ArrayList<TarantoolIndexPartMetadata>();
        if (indexPartsValue.size() > 0) {
            indexParts = indexPartsValue.get(0).isArrayValue() ? indexPartsValue.list().stream().map(partValue -> new TarantoolIndexPartMetadata(partValue.asArrayValue().get(0).asIntegerValue().asInt(), partValue.asArrayValue().get(1).asStringValue().asString())).collect(Collectors.toList()) : indexPartsValue.list().stream().map(partValue -> new TarantoolIndexPartMetadata(((Value)partValue.asMapValue().map().get(INDEX_FIELD_KEY)).asIntegerValue().asInt(), ((Value)partValue.asMapValue().map().get(INDEX_TYPE_KEY)).asStringValue().asString())).collect(Collectors.toList());
        }
        metadata.setIndexParts(indexParts);
        return metadata;
    }
}

