/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.TarantoolSimpleResultMapperFactory;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.AbstractTarantoolMetadata;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolIndexMetadataConverter;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.metadata.TarantoolSpaceMetadataConverter;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import io.tarantool.driver.protocol.TarantoolIteratorType;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.requests.TarantoolSelectRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.ArrayValue;

public class TarantoolMetadata
extends AbstractTarantoolMetadata {
    private static final int VSPACE_SPACE_ID = 281;
    private static final int VINDEX_SPACE_ID = 289;
    private final TarantoolSpaceMetadataConverter spaceMetadataMapper;
    private final TarantoolIndexMetadataConverter indexMetadataMapper;
    private final TarantoolClientConfig config;
    private final TarantoolConnectionManager connectionManager;
    private final TarantoolSimpleResultMapperFactory mapperFactory;

    public TarantoolMetadata(TarantoolClientConfig config, TarantoolConnectionManager connectionManager) {
        this.spaceMetadataMapper = new TarantoolSpaceMetadataConverter(config.getMessagePackMapper());
        this.indexMetadataMapper = new TarantoolIndexMetadataConverter(config.getMessagePackMapper());
        this.config = config;
        this.connectionManager = connectionManager;
        this.mapperFactory = new TarantoolSimpleResultMapperFactory(config.getMessagePackMapper());
    }

    @Override
    public CompletableFuture<Void> populateMetadata() throws TarantoolClientException {
        CompletableFuture<TarantoolResult<TarantoolSpaceMetadata>> spaces = this.select(281, this.spaceMetadataMapper);
        CompletableFuture<TarantoolResult<TarantoolIndexMetadata>> indexes = this.select(289, this.indexMetadataMapper);
        return spaces.thenAcceptBoth(indexes, (spacesCollection, indexesCollection) -> {
            this.spaceMetadata.clear();
            this.spaceMetadataById.clear();
            this.indexMetadata.clear();
            this.indexMetadataBySpaceId.clear();
            spacesCollection.forEach(meta -> {
                this.spaceMetadata.put(meta.getSpaceName(), meta);
                this.spaceMetadataById.put(meta.getSpaceId(), meta);
            });
            indexesCollection.forEach(meta -> {
                String spaceName = ((TarantoolSpaceMetadata)this.spaceMetadataById.get(meta.getSpaceId())).getSpaceName();
                this.indexMetadata.putIfAbsent(spaceName, new HashMap());
                ((Map)this.indexMetadata.get(spaceName)).put(meta.getIndexName(), meta);
                this.indexMetadataBySpaceId.putIfAbsent(meta.getSpaceId(), new HashMap());
                ((Map)this.indexMetadataBySpaceId.get(meta.getSpaceId())).put(meta.getIndexName(), meta);
            });
        });
    }

    private <T> CompletableFuture<TarantoolResult<T>> select(int spaceId, ValueConverter<ArrayValue, T> resultMapper) throws TarantoolClientException {
        try {
            Conditions query = Conditions.any();
            TarantoolIndexQuery indexQuery = new TarantoolIndexQuery(0).withIteratorType(TarantoolIteratorType.ITER_ALL);
            TarantoolSelectRequest request = new TarantoolSelectRequest.Builder().withSpaceId(spaceId).withIndexId(indexQuery.getIndexId()).withIteratorType(indexQuery.getIteratorType()).withKeyValues(indexQuery.getKeyValues()).withLimit(query.getLimit()).withOffset(query.getOffset()).build(this.config.getMessagePackMapper());
            return this.connectionManager.getConnection().sendRequest(request, this.mapperFactory.withConverter((ValueConverter)resultMapper));
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }
}

