/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.metadata.TarantoolFieldMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TarantoolSpaceMetadata {
    private int spaceId;
    private int ownerId;
    private String spaceName;
    private Map<String, TarantoolFieldMetadata> spaceFormatMetadata;
    private List<TarantoolFieldMetadata> spaceFormatMetadataAsList;

    public int getSpaceId() {
        return this.spaceId;
    }

    void setSpaceId(int spaceId) {
        this.spaceId = spaceId;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    void setOwnerId(int ownerId) {
        this.ownerId = ownerId;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public Map<String, TarantoolFieldMetadata> getSpaceFormatMetadata() {
        return this.spaceFormatMetadata;
    }

    void setSpaceFormatMetadata(Map<String, TarantoolFieldMetadata> spaceFormatMetadata) {
        this.spaceFormatMetadata = spaceFormatMetadata;
        this.spaceFormatMetadataAsList = new ArrayList<TarantoolFieldMetadata>(spaceFormatMetadata.values());
    }

    public Optional<TarantoolFieldMetadata> getFieldByName(String fieldName) {
        TarantoolFieldMetadata fieldMetadata = this.spaceFormatMetadata.get(fieldName);
        return Optional.ofNullable(fieldMetadata);
    }

    public Optional<TarantoolFieldMetadata> getFieldByPosition(int fieldPosition) {
        if (fieldPosition >= this.spaceFormatMetadataAsList.size() || fieldPosition < 0) {
            return Optional.empty();
        }
        TarantoolFieldMetadata fieldMetadata = this.spaceFormatMetadataAsList.get(fieldPosition);
        return Optional.of(fieldMetadata);
    }

    public int getFieldPositionByName(String fieldName) {
        return this.getFieldByName(fieldName).map(TarantoolFieldMetadata::getFieldPosition).orElse(-1);
    }

    public Optional<String> getFieldNameByPosition(int fieldPosition) {
        return this.getFieldByPosition(fieldPosition).map(TarantoolFieldMetadata::getFieldName);
    }

    public String toString() {
        return "TarantoolSpaceMetadata{spaceId=" + this.spaceId + ", ownerId=" + this.ownerId + ", spaceName='" + this.spaceName + '\'' + ", spaceFormatMetadata=" + this.spaceFormatMetadata + ", spaceFormatMetadataAsList=" + this.spaceFormatMetadataAsList + '}';
    }
}

