/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public class TarantoolSpaceMetadataConverter
implements ValueConverter<ArrayValue, TarantoolSpaceMetadata> {
    private static final ImmutableStringValue FORMAT_FIELD_NAME = new ImmutableStringValueImpl("name");
    private static final ImmutableStringValue FORMAT_FIELD_TYPE = new ImmutableStringValueImpl("type");
    private MessagePackValueMapper mapper;

    public TarantoolSpaceMetadataConverter(MessagePackValueMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public TarantoolSpaceMetadata fromValue(ArrayValue value) {
        Iterator it = value.iterator();
        TarantoolSpaceMetadata metadata = new TarantoolSpaceMetadata();
        metadata.setSpaceId((Integer)this.mapper.fromValue(((Value)it.next()).asIntegerValue()));
        metadata.setOwnerId((Integer)this.mapper.fromValue(((Value)it.next()).asIntegerValue()));
        metadata.setSpaceName((String)this.mapper.fromValue(((Value)it.next()).asStringValue()));
        Value spaceMetadataValue = (Value)it.next();
        while (!spaceMetadataValue.isArrayValue()) {
            spaceMetadataValue = (Value)it.next();
        }
        LinkedHashMap<String, TarantoolFieldMetadata> spaceFormatMetadata = new LinkedHashMap<String, TarantoolFieldMetadata>();
        int fieldPosition = 0;
        for (Value fieldValueMetadata : spaceMetadataValue.asArrayValue()) {
            Map fieldMap = fieldValueMetadata.asMapValue().map();
            spaceFormatMetadata.put(((Value)fieldMap.get(FORMAT_FIELD_NAME)).toString(), new TarantoolFieldMetadata(((Value)fieldMap.get(FORMAT_FIELD_NAME)).toString(), ((Value)fieldMap.get(FORMAT_FIELD_TYPE)).toString(), fieldPosition));
            ++fieldPosition;
        }
        metadata.setSpaceFormatMetadata(spaceFormatMetadata);
        return metadata;
    }
}

