/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.value.ImmutableIntegerValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public final class TarantoolHeader
implements Packable {
    private static final int IPROTO_REQUEST_TYPE = 0;
    private static final int IPROTO_SYNC = 1;
    private static final int IPROTO_SCHEMA_VERSION = 5;
    private Long sync;
    private Long code;
    private Long schemaVersion;

    private TarantoolHeader() {
    }

    TarantoolHeader(Long sync, Long code) {
        this.sync = sync;
        this.code = code;
    }

    TarantoolHeader(Long sync, Long code, Long schemaVersion) {
        this.sync = sync;
        this.code = code;
        this.schemaVersion = schemaVersion;
    }

    private void setSync(Long sync) {
        this.sync = sync;
    }

    public Long getSync() {
        return this.sync;
    }

    private void setCode(Long code) {
        this.code = code;
    }

    Long getCode() {
        return this.code;
    }

    private void setSchemaVersion(Long schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    private Long getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public Value toMessagePackValue(MessagePackObjectMapper mapper) {
        HashMap<ImmutableIntegerValue, ImmutableIntegerValue> values = new HashMap<ImmutableIntegerValue, ImmutableIntegerValue>();
        values.put(ValueFactory.newInteger((int)0), ValueFactory.newInteger((long)this.code));
        values.put(ValueFactory.newInteger((int)1), ValueFactory.newInteger((long)this.sync));
        if (this.schemaVersion != null) {
            values.put(ValueFactory.newInteger((int)5), ValueFactory.newInteger((long)this.schemaVersion));
        }
        return ValueFactory.newMap(values);
    }

    public static TarantoolHeader fromMessagePackValue(Value value) throws TarantoolProtocolException {
        if (!value.isMapValue()) {
            throw new TarantoolProtocolException("TarantoolHeader can be unpacked only from MP_MAP, received " + value.toString());
        }
        Map values = value.asMapValue().map();
        TarantoolHeader header = new TarantoolHeader();
        block5: for (Value key : values.keySet()) {
            if (!key.isIntegerValue()) {
                throw new TarantoolProtocolException("TarantoolHeader keys must be of MP_INT type");
            }
            Value field = (Value)values.get(key);
            if (!field.isIntegerValue()) {
                throw new TarantoolProtocolException("TarantoolHeader values must be of MP_INT type");
            }
            switch (key.asIntegerValue().asInt()) {
                case 0: {
                    header.setCode(field.asIntegerValue().asLong());
                    continue block5;
                }
                case 1: {
                    header.setSync(field.asIntegerValue().asLong());
                    continue block5;
                }
                case 5: {
                    header.setSchemaVersion(field.asIntegerValue().asLong());
                    continue block5;
                }
            }
            throw new TarantoolProtocolException("Unsupported header field {}", key.asIntegerValue().asLong());
        }
        if (header.getCode() == null) {
            throw new TarantoolProtocolException("No request or response code found");
        }
        if (header.getSync() == null) {
            throw new TarantoolProtocolException("No sync ID found");
        }
        return header;
    }
}

