/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.mappers.TarantoolCallResultMapper;
import io.tarantool.driver.proxy.AbstractProxyOperation;
import io.tarantool.driver.proxy.CRUDOperationOptions;
import io.tarantool.driver.utils.Assert;
import java.util.Arrays;
import java.util.List;

public final class ReplaceProxyOperation<T>
extends AbstractProxyOperation<T> {
    ReplaceProxyOperation(TarantoolClient client, String functionName, List<?> arguments, TarantoolCallResultMapper<T> resultMapper) {
        super(client, functionName, arguments, resultMapper);
    }

    public static final class Builder<T> {
        private TarantoolClient client;
        private String spaceName;
        private String functionName;
        private TarantoolTuple tuple;
        private TarantoolCallResultMapper<T> resultMapper;

        public Builder<T> withClient(TarantoolClient client) {
            this.client = client;
            return this;
        }

        public Builder<T> withSpaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public Builder<T> withFunctionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder<T> withTuple(TarantoolTuple tuple) {
            this.tuple = tuple;
            return this;
        }

        public Builder<T> withResultMapper(TarantoolCallResultMapper<T> resultMapper) {
            this.resultMapper = resultMapper;
            return this;
        }

        public ReplaceProxyOperation<T> build() {
            Assert.notNull(this.client, "Tarantool client should not be null");
            Assert.notNull(this.spaceName, "Tarantool spaceName should not be null");
            Assert.notNull(this.functionName, "Proxy delete function name should not be null");
            Assert.notNull(this.tuple, "Tarantool tuple should not be null");
            Assert.notNull(this.resultMapper, "Result tuple mapper should not be null");
            TarantoolClientConfig config = this.client.getConfig();
            CRUDOperationOptions options = CRUDOperationOptions.builder().withTimeout(config.getRequestTimeout()).build();
            List<Object> arguments = Arrays.asList(this.spaceName, this.tuple.getFields(), options.asMap());
            return new ReplaceProxyOperation<T>(this.client, this.functionName, arguments, this.resultMapper);
        }
    }
}

