/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.tarantool.driver.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolVersion;
import io.tarantool.driver.api.CallResult;
import io.tarantool.driver.api.MultiValueCallResult;
import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.core.TarantoolConnectionFactory;
import io.tarantool.driver.core.TarantoolConnectionListeners;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolSpaceNotFoundException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.DefaultResultMapperFactoryFactory;
import io.tarantool.driver.mappers.DefaultSingleValueResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.MultiValueListConverter;
import io.tarantool.driver.mappers.ResultMapperFactoryFactory;
import io.tarantool.driver.mappers.SingleValueTarantoolResultMapperFactory;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.SpacesMetadataProvider;
import io.tarantool.driver.metadata.TarantoolMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolMetadataProvider;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.requests.TarantoolCallRequest;
import io.tarantool.driver.protocol.requests.TarantoolEvalRequest;
import io.tarantool.driver.utils.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public abstract class AbstractTarantoolClient<T extends Packable, R extends Collection<T>>
implements TarantoolClient<T, R> {
    private final NioEventLoopGroup eventLoopGroup;
    private final TarantoolClientConfig config;
    private final Bootstrap bootstrap;
    private final TarantoolConnectionFactory connectionFactory;
    private final TarantoolConnectionListeners listeners;
    private final AtomicReference<TarantoolConnectionManager> connectionManagerHolder = new AtomicReference();
    private final AtomicReference<TarantoolMetadata> metadataHolder = new AtomicReference();
    private final DefaultResultMapperFactoryFactory mapperFactoryFactory;
    private final SpacesMetadataProvider metadataProvider;

    public AbstractTarantoolClient(TarantoolClientConfig config) {
        this(config, new TarantoolConnectionListeners());
    }

    protected AbstractTarantoolClient(TarantoolClientConfig config, ConnectionSelectionStrategyFactory selectionStrategyFactory, TarantoolConnectionListeners listeners) {
        this(config, listeners);
    }

    public AbstractTarantoolClient(TarantoolClientConfig config, TarantoolConnectionListeners listeners) {
        Assert.notNull(config, "Tarantool client config must not be null");
        Assert.notNull(listeners, "Tarantool connection listeners must not be null");
        this.config = config;
        this.mapperFactoryFactory = new DefaultResultMapperFactoryFactory();
        this.eventLoopGroup = new NioEventLoopGroup();
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout());
        this.connectionFactory = new TarantoolConnectionFactory(config, this.bootstrap);
        this.listeners = listeners;
        this.metadataProvider = new SpacesMetadataProvider(this, config.getMessagePackMapper());
    }

    protected abstract TarantoolConnectionManager connectionManager(TarantoolClientConfig var1, TarantoolConnectionFactory var2, TarantoolConnectionListeners var3);

    private TarantoolConnectionManager connectionManager() {
        if (this.connectionManagerHolder.get() == null) {
            this.connectionManagerHolder.compareAndSet(null, this.connectionManager(this.config, this.connectionFactory, this.listeners));
        }
        return this.connectionManagerHolder.get();
    }

    @Override
    public TarantoolVersion getVersion() throws TarantoolClientException {
        return this.connectionManager().getConnection().getVersion();
    }

    @Override
    public TarantoolSpaceOperations<T, R> space(String spaceName) throws TarantoolClientException {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        TarantoolMetadataOperations metadata = this.metadata();
        Optional<TarantoolSpaceMetadata> meta = metadata.getSpaceByName(spaceName);
        if (!meta.isPresent()) {
            throw new TarantoolSpaceNotFoundException(spaceName);
        }
        return this.spaceOperations(this.config, this.connectionManager(), metadata, meta.get());
    }

    @Override
    public TarantoolSpaceOperations<T, R> space(int spaceId) throws TarantoolClientException {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        TarantoolMetadataOperations metadata = this.metadata();
        Optional<TarantoolSpaceMetadata> meta = metadata.getSpaceById(spaceId);
        if (!meta.isPresent()) {
            throw new TarantoolSpaceNotFoundException(spaceId);
        }
        return this.spaceOperations(this.config, this.connectionManager(), metadata, meta.get());
    }

    protected abstract TarantoolSpaceOperations<T, R> spaceOperations(TarantoolClientConfig var1, TarantoolConnectionManager var2, TarantoolMetadataOperations var3, TarantoolSpaceMetadata var4);

    @Override
    public TarantoolMetadataOperations metadata() throws TarantoolClientException {
        if (this.metadataHolder.get() == null) {
            this.metadataHolder.compareAndSet(null, new TarantoolMetadata(this.metadataProvider()));
        }
        return this.metadataHolder.get();
    }

    @Override
    public TarantoolMetadataProvider metadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName) throws TarantoolClientException {
        return this.call(functionName, Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, Object ... arguments) throws TarantoolClientException {
        return this.call(functionName, Arrays.asList(arguments));
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, List<?> arguments) throws TarantoolClientException {
        return this.call(functionName, arguments, this.config.getMessagePackMapper());
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, List<?> arguments, MessagePackMapper mapper) throws TarantoolClientException {
        return this.makeRequest(functionName, arguments, mapper, mapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, Class<T> tupleClass) throws TarantoolClientException {
        return this.call(functionName, Collections.emptyList(), tupleClass);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>> resultMapper) throws TarantoolClientException {
        return this.call(functionName, Collections.emptyList(), resultMapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, List<?> arguments, Class<T> tupleClass) throws TarantoolClientException {
        return this.call(functionName, arguments, (MessagePackObjectMapper)this.config.getMessagePackMapper(), tupleClass);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, List<?> arguments, CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>> resultMapper) throws TarantoolClientException {
        return this.call(functionName, arguments, (MessagePackObjectMapper)this.config.getMessagePackMapper(), resultMapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Class<T> tupleClass) throws TarantoolClientException {
        ValueConverter<ArrayValue, T> converter = this.getArrayValueConverter(tupleClass);
        return this.call(functionName, arguments, argumentsMapper, this.getMapperFactory(tupleClass).withTarantoolResultConverter(converter));
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>> resultMapper) throws TarantoolClientException {
        return this.callForSingleResult(functionName, arguments, argumentsMapper, (CallResultMapper)resultMapper);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, List<?> arguments, Class<S> resultClass) throws TarantoolClientException {
        return this.callForSingleResult(functionName, arguments, (MessagePackObjectMapper)this.config.getMessagePackMapper(), resultClass);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, List<?> arguments, CallResultMapper<S, SingleValueCallResult<S>> resultMapper) throws TarantoolClientException {
        return this.callForSingleResult(functionName, arguments, (MessagePackObjectMapper)this.config.getMessagePackMapper(), resultMapper);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Class<S> resultClass) throws TarantoolClientException {
        return this.callForSingleResult(functionName, (List<?>)Collections.emptyList(), resultClass);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, CallResultMapper<S, SingleValueCallResult<S>> resultMapper) throws TarantoolClientException {
        return this.callForSingleResult(functionName, (List<?>)Collections.emptyList(), resultMapper);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Class<S> resultClass) throws TarantoolClientException {
        return this.callForSingleResult(functionName, arguments, argumentsMapper, this.getDefaultSingleValueMapper(resultClass));
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<S, SingleValueCallResult<S>> resultMapper) throws TarantoolClientException {
        return this.makeRequestForSingleResult(functionName, arguments, argumentsMapper, resultMapper).thenApply(CallResult::value);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, Class<R> resultClass) throws TarantoolClientException {
        return this.callForMultiResult(functionName, arguments, (MessagePackObjectMapper)this.config.getMessagePackMapper(), resultClass);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.callForMultiResult(functionName, arguments, (MessagePackObjectMapper)this.config.getMessagePackMapper(), resultMapper);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Class<R> resultClass) throws TarantoolClientException {
        return this.callForMultiResult(functionName, Collections.emptyList(), resultClass);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.callForMultiResult(functionName, Collections.emptyList(), resultMapper);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Class<R> resultClass) throws TarantoolClientException {
        return this.callForMultiResult(functionName, arguments, argumentsMapper, this.withResultClass(resultClass));
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.makeRequestForMultiResult(functionName, arguments, argumentsMapper, resultMapper).thenApply(CallResult::value);
    }

    private <T> CompletableFuture<CallResult<T>> makeRequestForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) {
        return this.makeRequest(functionName, arguments, argumentsMapper, resultMapper);
    }

    private <T, R extends List<T>> CompletableFuture<CallResult<R>> makeRequestForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) {
        return this.makeRequest(functionName, arguments, argumentsMapper, resultMapper);
    }

    private <S> CompletableFuture<S> makeRequest(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolCallRequest.Builder builder = new TarantoolCallRequest.Builder().withFunctionName(functionName);
            if (arguments.size() > 0) {
                builder.withArguments(arguments);
            }
            TarantoolCallRequest request = builder.build(argumentsMapper);
            return this.connectionManager().getConnection().sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    private <T, R extends List<T>> CallResultMapper<R, MultiValueCallResult<T, R>> withResultClass(Class<R> resultClass) {
        return this.mapperFactoryFactory.multiValueResultMapperFactory(resultClass).withMultiValueResultConverter(new MultiValueListConverter<R>(this.getValueConverter(resultClass)));
    }

    private <T> SingleValueTarantoolResultMapperFactory<T> getMapperFactory(Class<T> resultClass) {
        return this.mapperFactoryFactory.singleValueTarantoolResultMapperFactory(resultClass);
    }

    private <T> CallResultMapper<T, SingleValueCallResult<T>> getDefaultSingleValueMapper(Class<T> tupleClass) {
        return new DefaultSingleValueResultMapper<T>(this.config.getMessagePackMapper(), tupleClass);
    }

    private <T> ValueConverter<Value, T> getValueConverter(Class<T> tupleClass) {
        return this.getConverter(Value.class, tupleClass);
    }

    private <T> ValueConverter<ArrayValue, T> getArrayValueConverter(Class<T> tupleClass) {
        return this.getConverter(ArrayValue.class, tupleClass);
    }

    private <T> ValueConverter<? extends Value, T> getConverter(Class<? extends Value> valueClass, Class<T> tupleClass) {
        Optional<ValueConverter<Value, T>> converter = this.config.getMessagePackMapper().getValueConverter(valueClass, tupleClass);
        if (!converter.isPresent()) {
            throw new TarantoolClientException("No converter for value class %s and type %s is present", valueClass, tupleClass);
        }
        return converter.get();
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression) throws TarantoolClientException {
        return this.eval(expression, Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments) throws TarantoolClientException {
        return this.eval(expression, arguments, this.config.getMessagePackMapper());
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        return this.eval(expression, Collections.emptyList(), resultMapper);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        return this.eval(expression, arguments, this.config.getMessagePackMapper(), resultMapper);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments, MessagePackObjectMapper argumentsMapper, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolEvalRequest request = new TarantoolEvalRequest.Builder().withExpression(expression).withArguments(arguments).build(argumentsMapper);
            return this.connectionManager().getConnection().sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public TarantoolClientConfig getConfig() {
        return this.config;
    }

    protected Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Override
    public void close() throws Exception {
        try {
            this.connectionManager().close();
        }
        finally {
            try {
                this.eventLoopGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public TarantoolConnectionListeners getListeners() {
        return this.listeners;
    }

    @Override
    public ResultMapperFactoryFactory getResultMapperFactoryFactory() {
        return this.mapperFactoryFactory;
    }
}

