/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.ClusterTarantoolClient;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolClusterAddressProvider;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.space.TarantoolTupleSpace;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.core.TarantoolConnectionSelectionStrategies;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import java.util.Collection;
import java.util.Collections;

public class ClusterTarantoolTupleClient
extends ClusterTarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> {
    public ClusterTarantoolTupleClient() {
        this(new SimpleTarantoolCredentials());
    }

    public ClusterTarantoolTupleClient(TarantoolCredentials credentials) {
        this(credentials, Collections.singletonList(new TarantoolServerAddress()));
    }

    public ClusterTarantoolTupleClient(TarantoolCredentials credentials, String host, int port) {
        this(credentials, Collections.singletonList(new TarantoolServerAddress(host, port)));
    }

    public ClusterTarantoolTupleClient(TarantoolClientConfig config, String host, int port) {
        this(config, Collections.singletonList(new TarantoolServerAddress(host, port)));
    }

    public ClusterTarantoolTupleClient(TarantoolCredentials credentials, TarantoolServerAddress address) {
        this(TarantoolClientConfig.builder().withCredentials(credentials).build(), address);
    }

    public ClusterTarantoolTupleClient(TarantoolClientConfig config, TarantoolServerAddress address) {
        this(config, () -> Collections.singletonList(address));
    }

    public ClusterTarantoolTupleClient(TarantoolCredentials credentials, Collection<TarantoolServerAddress> addresses) {
        this(TarantoolClientConfig.builder().withCredentials(credentials).withConnectionSelectionStrategyFactory(TarantoolConnectionSelectionStrategies.ParallelRoundRobinStrategyFactory.INSTANCE).build(), () -> addresses);
    }

    public ClusterTarantoolTupleClient(TarantoolClientConfig config, Collection<TarantoolServerAddress> addresses) {
        this(config, () -> addresses);
    }

    public ClusterTarantoolTupleClient(TarantoolClientConfig config, TarantoolClusterAddressProvider addressProvider) {
        super(config, addressProvider);
    }

    @Override
    protected TarantoolSpaceOperations<TarantoolTuple, TarantoolResult<TarantoolTuple>> spaceOperations(TarantoolClientConfig config, TarantoolConnectionManager connectionManager, TarantoolMetadataOperations metadata, TarantoolSpaceMetadata spaceMetadata) {
        return new TarantoolTupleSpace(this, config, connectionManager, metadata, spaceMetadata);
    }
}

