/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.utils.Assert;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public interface RequestRetryPolicy {
    public boolean canRetryRequest(Throwable var1);

    default public long getOperationTimeout() {
        return TimeUnit.HOURS.toMillis(1L);
    }

    default public <T> CompletableFuture<T> wrapOperation(Supplier<CompletableFuture<T>> operation, Executor executor) {
        Assert.notNull(operation, "Operation must not be null");
        Assert.notNull(executor, "Executor must not be null");
        return operation.get().handleAsync((value, ex) -> {
            if (ex == null) {
                return value;
            }
            do {
                try {
                    return ((CompletableFuture)operation.get()).get(this.getOperationTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException e) {
                    ex = e;
                }
                catch (ExecutionException e) {
                    ex = e.getCause();
                }
            } while (this.canRetryRequest((Throwable)ex));
            throw new CompletionException((Throwable)ex);
        });
    }
}

