/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.RequestRetryPolicy;
import io.tarantool.driver.RequestRetryPolicyFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class TarantoolRequestRetryPolicies {
    private TarantoolRequestRetryPolicies() {
    }

    public static <T extends Function<Throwable, Boolean>> AttemptsBoundRetryPolicyFactory<T> byNumberOfAttempts(int numberOfAttempts, T exceptionCheck) {
        return new AttemptsBoundRetryPolicyFactory<T>(numberOfAttempts, exceptionCheck);
    }

    public static <T extends Function<Throwable, Boolean>> AttemptsBoundRetryPolicyFactory<T> byNumberOfAttempts(int numberOfAttempts, long timeout, T exceptionCheck) {
        return new AttemptsBoundRetryPolicyFactory<T>(numberOfAttempts, timeout, exceptionCheck);
    }

    public static final class AttemptsBoundRetryPolicyFactory<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicyFactory {
        private final int numberOfAttempts;
        private long timeout = TimeUnit.HOURS.toMillis(1L);
        private final T callback;

        public AttemptsBoundRetryPolicyFactory(int numberOfAttempts, T callback) {
            this.numberOfAttempts = numberOfAttempts;
            this.callback = callback;
        }

        public AttemptsBoundRetryPolicyFactory(int numberOfAttempts, long timeout, T callback) {
            this.numberOfAttempts = numberOfAttempts;
            this.timeout = timeout;
            this.callback = callback;
        }

        @Override
        public RequestRetryPolicy create() {
            return new AttemptsBoundRetryPolicy<T>(this.numberOfAttempts, this.timeout, this.callback);
        }
    }

    public static final class AttemptsBoundRetryPolicy<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicy {
        private int attempts;
        private long timeout = TimeUnit.HOURS.toMillis(1L);
        private final T callback;

        @Override
        public long getOperationTimeout() {
            return this.timeout;
        }

        public AttemptsBoundRetryPolicy(int attempts, T callback) {
            this.attempts = attempts;
            this.callback = callback;
        }

        public AttemptsBoundRetryPolicy(int attempts, long timeout, T callback) {
            this.attempts = attempts;
            this.callback = callback;
            this.timeout = timeout;
        }

        @Override
        public boolean canRetryRequest(Throwable throwable) {
            if (((Boolean)this.callback.apply((Throwable)throwable)).booleanValue() && this.attempts > 0) {
                --this.attempts;
                return true;
            }
            return false;
        }
    }
}

