/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api;

import io.tarantool.driver.api.MultiValueCallResult;
import io.tarantool.driver.exceptions.TarantoolFunctionCallException;
import io.tarantool.driver.mappers.ValueConverter;
import java.util.List;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class MultiValueCallResultImpl<T, R extends List<T>>
implements MultiValueCallResult<T, R> {
    private final R value;

    public MultiValueCallResultImpl(Value result, ValueConverter<ArrayValue, R> valueConverter) {
        if (result == null) {
            throw new TarantoolFunctionCallException("Function call result is null");
        }
        if (!result.isArrayValue()) {
            throw new TarantoolFunctionCallException("Function call result is not a MessagePack array");
        }
        this.value = (List)valueConverter.fromValue(result.asArrayValue());
    }

    @Override
    public R value() {
        return this.value;
    }
}

